/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import com.google.common.collect.LinkedHashMultimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.spf4j.base.Either;
import org.spf4j.base.Pair;
import org.spf4j.base.Runtime;
import org.spf4j.base.Throwables;
import org.spf4j.recyclable.ObjectBorower;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Scanable;
import org.spf4j.recyclable.SmartRecyclingSupplier;

final class SimpleSmartObjectPool<T>
implements SmartRecyclingSupplier<T> {
    private int maxSize;
    private int waitingForReturn;
    private final LinkedHashMultimap<ObjectBorower<T>, T> borrowedObjects;
    private final List<T> availableObjects;
    private final ReentrantLock lock;
    private final Condition available;
    private final RecyclingSupplier.Factory<T> factory;

    SimpleSmartObjectPool(int initialSize, int maxSize, RecyclingSupplier.Factory<T> factory, boolean fair) throws ObjectCreationException {
        this.maxSize = maxSize;
        this.factory = factory;
        this.lock = new ReentrantLock(fair);
        this.available = this.lock.newCondition();
        this.borrowedObjects = LinkedHashMultimap.create();
        this.availableObjects = new ArrayList<T>(initialSize);
        for (int i = 0; i < initialSize; ++i) {
            this.availableObjects.add(factory.create());
        }
        this.waitingForReturn = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public T get(ObjectBorower borower) throws InterruptedException, TimeoutException, ObjectCreationException {
        long deadline = Runtime.getDeadline();
        this.lock.lock();
        try {
            if (this.availableObjects.size() - this.waitingForReturn > 0) {
                Iterator<T> it = this.availableObjects.iterator();
                T object2 = it.next();
                it.remove();
                this.borrowedObjects.put((Object)borower, object2);
                T t = object2;
                return t;
            }
            if (this.borrowedObjects.size() < this.maxSize) {
                T object = this.factory.create();
                this.borrowedObjects.put((Object)borower, object);
                T object2 = object;
                return object2;
            }
            if (this.borrowedObjects.isEmpty() && this.availableObjects.isEmpty()) {
                throw new RuntimeException("Pool is probably closing down or is missconfigured with size 0 " + this);
            }
            while (this.borrowedObjects.isEmpty()) {
                this.available.await(1L, TimeUnit.MILLISECONDS);
                if (deadline >= System.currentTimeMillis()) continue;
                throw new TimeoutException("Object wait timeout expired, deadline = " + deadline);
            }
            for (ObjectBorower b : this.borrowedObjects.keySet()) {
                Object object;
                if (borower == b || (object = b.tryReturnObjectIfNotInUse()) == null) continue;
                if (!this.borrowedObjects.remove((Object)b, object)) {
                    throw new IllegalStateException("Returned Object hasn't been borrowed " + object);
                }
                this.borrowedObjects.put((Object)borower, object);
                Object object3 = object;
                return (T)object3;
            }
            boolean requestMade = false;
            while (!requestMade) {
                boolean hasValidBorowers = false;
                for (ObjectBorower b : this.borrowedObjects.keySet()) {
                    if (borower == b) continue;
                    hasValidBorowers = true;
                    Either objOrPromise = b.tryRequestReturnObject();
                    if (objOrPromise.isRight()) {
                        Object obj = objOrPromise.getRight();
                        if (!this.borrowedObjects.remove((Object)b, obj)) {
                            throw new IllegalStateException("Returned Object " + obj + " hasn't been borrowed: " + this.borrowedObjects);
                        }
                        this.borrowedObjects.put((Object)borower, obj);
                        Object t = obj;
                        return t;
                    }
                    requestMade = objOrPromise.getLeft() == ObjectBorower.Action.REQUEST_MADE;
                    if (!requestMade) continue;
                    break;
                }
                if (!hasValidBorowers) {
                    throw new IllegalStateException("Borrower asks for more than possible " + borower);
                }
                if (requestMade) continue;
                do {
                    this.available.await(1L, TimeUnit.MILLISECONDS);
                    if (deadline >= System.currentTimeMillis()) continue;
                    throw new TimeoutException("Object wait timeout expired, deadline = " + deadline);
                } while (this.borrowedObjects.isEmpty());
            }
            ++this.waitingForReturn;
            while (this.availableObjects.isEmpty()) {
                long waitTime = deadline - System.currentTimeMillis();
                if (waitTime <= 0L) {
                    throw new TimeoutException("Object wait timeout expired, deadline = " + deadline);
                }
                if (this.available.await(waitTime, TimeUnit.MILLISECONDS)) continue;
                throw new TimeoutException("Object wait timeout expired, deadline = " + deadline);
            }
            --this.waitingForReturn;
            Iterator<T> it = this.availableObjects.iterator();
            T objectT = it.next();
            it.remove();
            this.borrowedObjects.put((Object)borower, objectT);
            T t = objectT;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(T object, ObjectBorower borower) {
        this.lock.lock();
        try {
            if (!this.borrowedObjects.remove((Object)borower, object)) {
                Map.Entry foundEntry = null;
                for (Map.Entry entry : this.borrowedObjects.entries()) {
                    ObjectBorower lb = (ObjectBorower)entry.getKey();
                    if (lb == borower || !lb.nevermind(entry.getValue())) continue;
                    foundEntry = entry;
                    break;
                }
                if (foundEntry == null) {
                    throw new IllegalStateException("Object " + object + " has not been borrowed from this pool");
                }
                this.borrowedObjects.remove(foundEntry.getKey(), foundEntry.getValue());
            }
            this.availableObjects.add(object);
            this.available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean tryDispose(long timeoutMillis) throws ObjectDisposeException, InterruptedException {
        long deadline = System.currentTimeMillis() + timeoutMillis;
        this.lock.lock();
        try {
            this.maxSize = 0;
            ArrayList returnedObjects = new ArrayList();
            for (Map.Entry entry : this.borrowedObjects.asMap().entrySet()) {
                ObjectBorower borrower = (ObjectBorower)entry.getKey();
                int nrObjects = ((Collection)entry.getValue()).size();
                for (int i = 0; i < nrObjects; ++i) {
                    Either object = borrower.tryRequestReturnObject();
                    if (!object.isRight()) continue;
                    returnedObjects.add(Pair.of(borrower, object.getRight()));
                }
            }
            for (Pair bl : returnedObjects) {
                Object object = bl.getSecond();
                if (!this.borrowedObjects.remove(bl.getFirst(), object)) {
                    throw new IllegalStateException("Returned Object hasn't been borrowed " + object);
                }
                this.availableObjects.add(object);
            }
            ObjectDisposeException exception = this.disposeReturnedObjects(null);
            while (!this.borrowedObjects.isEmpty()) {
                boolean bl;
                long l = deadline - System.currentTimeMillis();
                if (l <= 0L) {
                    bl = false;
                    return bl;
                }
                if (!this.available.await(l, TimeUnit.MILLISECONDS)) {
                    bl = false;
                    return bl;
                }
                this.disposeReturnedObjects(exception);
            }
            if (exception != null) {
                throw exception;
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException | RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ObjectDisposeException disposeReturnedObjects(ObjectDisposeException exception) {
        ObjectDisposeException result = exception;
        for (T obj : this.availableObjects) {
            try {
                this.factory.dispose(obj);
            }
            catch (ObjectDisposeException ex) {
                if (result == null) {
                    result = ex;
                    continue;
                }
                result = Throwables.suppress(ex, result);
            }
            catch (Exception ex) {
                if (result == null) {
                    result = new ObjectDisposeException(ex);
                    continue;
                }
                result = Throwables.suppress(new ObjectDisposeException(ex), result);
            }
        }
        this.availableObjects.clear();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"EXS_EXCEPTION_SOFTENING_HAS_CHECKED"})
    public boolean scan(Scanable.ScanHandler<T> handler) throws Exception {
        this.lock.lock();
        Exception resEx = null;
        try {
            for (ObjectBorower objectBorower : this.borrowedObjects.keySet()) {
                Collection returned;
                try {
                    if (!objectBorower.scan(handler)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Exception e) {
                    resEx = resEx == null ? e : Throwables.suppress(e, resEx);
                }
                if ((returned = objectBorower.tryReturnObjectsIfNotNeededAnymore()) == null) continue;
                for (Object ro : returned) {
                    if (!this.borrowedObjects.remove((Object)objectBorower, ro)) {
                        throw new IllegalStateException("Object returned hasn't been borrowed" + ro);
                    }
                    this.availableObjects.add(ro);
                }
            }
            for (Object object : this.availableObjects) {
                try {
                    if (handler.handle(object)) continue;
                    boolean returned = false;
                    return returned;
                }
                catch (Exception e) {
                    if (resEx == null) {
                        resEx = e;
                        continue;
                    }
                    resEx = Throwables.suppress(e, resEx);
                }
            }
            if (resEx != null) {
                throw resEx;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReturnFromBorrowersIfNotInUse() throws InterruptedException {
        this.lock.lock();
        try {
            ArrayList returnedObjects = new ArrayList();
            for (ObjectBorower objectBorower : this.borrowedObjects.keySet()) {
                Collection objects = objectBorower.tryReturnObjectsIfNotInUse();
                if (objects == null) continue;
                for (Object object : objects) {
                    returnedObjects.add(Pair.of(objectBorower, object));
                }
            }
            for (Pair pair : returnedObjects) {
                Object object = pair.getSecond();
                this.borrowedObjects.remove(pair.getFirst(), object);
                this.availableObjects.add(object);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = "SimpleSmartObjectPool{maxSize=" + this.maxSize + ", borrowedObjects=" + this.borrowedObjects + ", returnedObjects=" + this.availableObjects + ", factory=" + this.factory + '}';
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

