/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.lang.ref.Reference;
import java.util.ArrayDeque;
import java.util.Deque;
import org.spf4j.base.IntMath;
import org.spf4j.base.ReferenceType;
import org.spf4j.recyclable.SizedRecyclingSupplier;

public final class Powerof2ThreadLocalRecyclingSupplier<T>
implements SizedRecyclingSupplier<T> {
    private final SizedRecyclingSupplier.Factory<T> factory;
    private final ReferenceType refType;
    private final ThreadLocal<Deque<Reference<T>>[]> localObjects;

    public Powerof2ThreadLocalRecyclingSupplier(SizedRecyclingSupplier.Factory<T> factory, ReferenceType refType) {
        this.factory = factory;
        this.refType = refType;
        this.localObjects = new ThreadLocal<Deque<Reference<T>>[]>(){

            @Override
            protected Deque<Reference<T>>[] initialValue() {
                Deque[] result = new Deque[28];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = new ArrayDeque();
                }
                return result;
            }
        };
    }

    @Override
    public T get(int size) {
        Reference<T> removeLast;
        T result;
        int idx;
        Deque<Reference<T>>[] available = this.localObjects.get();
        Deque<Reference<T>> refs = available[idx = IntMath.closestPowerOf2(size)];
        if (refs.isEmpty()) {
            int actualSize = 1 << idx;
            return this.factory.create(actualSize);
        }
        while ((result = (removeLast = refs.removeLast()).get()) == null && !refs.isEmpty()) {
        }
        if (result == null) {
            int actualSize = 1 << idx;
            return this.factory.create(actualSize);
        }
        return result;
    }

    @Override
    public void recycle(T object) {
        int size = this.factory.size(object);
        int idx = IntMath.closestPowerOf2(size);
        Deque<Reference<T>>[] available = this.localObjects.get();
        Deque<Reference<T>> refs = available[idx];
        refs.addLast(this.refType.create(object));
    }

    public String toString() {
        return "Powerof2ThreadLocalRecyclingSupplier{factory=" + this.factory + ", refType=" + (Object)((Object)this.refType) + '}';
    }
}

