/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable;

import java.util.concurrent.TimeoutException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.recyclable.Disposable;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;

@ParametersAreNonnullByDefault
public interface RecyclingSupplier<T>
extends Disposable {
    @Nonnull
    public T get() throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException;

    public void recycle(T var1, @Nullable Exception var2);

    public void recycle(T var1);

    @ParametersAreNonnullByDefault
    public static interface Factory<T> {
        public T create() throws ObjectCreationException;

        public void dispose(T var1) throws ObjectDisposeException;

        @Nullable
        @CheckReturnValue
        public boolean validate(T var1, @Nullable Exception var2) throws Exception;
    }
}

