/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.pool.jdbc;

import com.google.common.annotations.Beta;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.spf4j.pool.jdbc.JdbcConnectionFactory;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.impl.RecyclingSupplierBuilder;

@Beta
public final class PooledDataSource
implements DataSource {
    private final RecyclingSupplier<Connection> pool;

    public PooledDataSource(int coreSize, int maxSize, String driverName, String url, String user, String password) throws ObjectCreationException {
        JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory(driverName, url, user, password);
        RecyclingSupplierBuilder<Connection> builder = new RecyclingSupplierBuilder<Connection>(maxSize, jdbcConnectionFactory);
        this.pool = builder.build();
        jdbcConnectionFactory.setPool(this.pool);
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.pool.get();
        }
        catch (InterruptedException | TimeoutException | ObjectBorrowException | ObjectCreationException ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    public Connection getConnection(String username, String password) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public int getLoginTimeout() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.equals(DataSource.class) || iface.equals(PooledDataSource.class)) {
            return (T)this;
        }
        throw new SQLException("Not a wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.equals(DataSource.class) || iface.equals(PooledDataSource.class);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public String toString() {
        return "PooledDataSource{pool=" + this.pool + '}';
    }
}

