/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.io;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import java.io.IOException;
import java.io.OutputStream;
import org.spf4j.perf.MeasurementRecorderSource;

@CleanupObligation
public final class MeasuredOutputStream
extends OutputStream {
    private final OutputStream os;
    private final String from;
    private final MeasurementRecorderSource recorderSource;

    public MeasuredOutputStream(OutputStream os, String from, MeasurementRecorderSource recorderSource) {
        this.os = os;
        this.from = from;
        this.recorderSource = recorderSource;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        this.recorderSource.getRecorder(this.from).record(1L);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.os.write(b);
        this.recorderSource.getRecorder(this.from).record(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.recorderSource.getRecorder(this.from).record(len);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public String toString() {
        return "MeasuredOutputStream{os=" + this.os + ", from=" + this.from + ", recorderSource=" + this.recorderSource + '}';
    }
}

