/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.tsdb;

import com.google.common.base.Charsets;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import org.spf4j.io.Csv;
import org.spf4j.jmx.JmxExport;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.ms.Id2Info;

@ThreadSafe
public final class TSDBTxtMeasurementStore
implements MeasurementStore {
    private final BufferedWriter writer;
    private final String fileName;
    private static final Interner<String> INTERNER = Interners.newStrongInterner();

    public TSDBTxtMeasurementStore(String fileName) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), Charsets.UTF_8));
        this.fileName = (String)INTERNER.intern((Object)new File(fileName).getPath());
    }

    @Override
    public long alocateMeasurements(MeasurementsInfo measurement, int sampleTimeMillis) {
        return Id2Info.getId(measurement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveMeasurements(long tableId, long timeStampMillis, long ... measurements) throws IOException {
        MeasurementsInfo measurementInfo = Id2Info.getInfo(tableId);
        String groupName = measurementInfo.getMeasuredEntity().toString();
        String string = this.fileName;
        synchronized (string) {
            Csv.writeCsvElement(groupName, this.writer);
            this.writer.write(44);
            this.writer.write(Long.toString(timeStampMillis));
            for (int i = 0; i < measurements.length; ++i) {
                String measurementName = measurementInfo.getMeasurementName(i);
                this.writer.write(44);
                Csv.writeCsvElement(measurementName, this.writer);
                this.writer.write(44);
                this.writer.write(Long.toString(measurements[i]));
            }
            this.writer.write(10);
        }
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    @JmxExport(description="flush out buffers")
    public void flush() throws IOException {
        this.writer.flush();
    }

    public String toString() {
        return "TSDBTxtMeasurementStore{fileName=" + this.fileName + '}';
    }
}

