/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.graphite;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.SocketFactory;
import org.spf4j.base.Handler;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.ms.Id2Info;
import org.spf4j.perf.impl.ms.graphite.GraphiteUdpStore;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.Template;
import org.spf4j.recyclable.impl.RecyclingSupplierBuilder;

public final class GraphiteTcpStore
implements MeasurementStore {
    private final RecyclingSupplier<Writer> socketWriterSupplier;
    private final InetSocketAddress address;

    public GraphiteTcpStore(String hostPort) throws ObjectCreationException, URISyntaxException {
        this(new URI("graphiteTcp://" + hostPort));
    }

    public GraphiteTcpStore(URI uri) throws ObjectCreationException {
        this(uri.getHost(), uri.getPort());
    }

    public GraphiteTcpStore(String hostName, int port) throws ObjectCreationException {
        this(hostName, port, SocketFactory.getDefault());
    }

    public GraphiteTcpStore(String hostName, int port, SocketFactory socketFactory) throws ObjectCreationException {
        this.address = new InetSocketAddress(hostName, port);
        this.socketWriterSupplier = new RecyclingSupplierBuilder<Writer>(1, new WriterSupplierFactory(socketFactory, hostName, port)).build();
    }

    @Override
    public long alocateMeasurements(MeasurementsInfo measurement, int sampleTimeMillis) {
        return Id2Info.getId(measurement);
    }

    @Override
    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION"})
    public void saveMeasurements(long tableId, long timeStampMillis, long ... measurements) throws IOException {
        try {
            Template.doOnSupplied(new HandlerImpl(measurements, Id2Info.getInfo(tableId), timeStampMillis), this.socketWriterSupplier, 3, 1000, 60000);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return "GraphiteTcpStore{address=" + this.address + '}';
    }

    @Override
    public void close() {
        try {
            this.socketWriterSupplier.dispose();
        }
        catch (InterruptedException | ObjectDisposeException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void flush() {
    }

    private static class HandlerImpl
    implements Handler<Writer, IOException> {
        private final long[] measurements;
        private final MeasurementsInfo measurementInfo;
        private final long timeStampMillis;

        HandlerImpl(long[] measurements, MeasurementsInfo measurementInfo, long timeStampMillis) {
            this.measurements = measurements;
            this.measurementInfo = measurementInfo;
            this.timeStampMillis = timeStampMillis;
        }

        @Override
        public void handle(Writer socketWriter, long deadline) throws IOException {
            for (int i = 0; i < this.measurements.length; ++i) {
                GraphiteUdpStore.writeMetric(this.measurementInfo, this.measurementInfo.getMeasurementName(i), this.measurements[i], this.timeStampMillis, socketWriter);
            }
            socketWriter.flush();
        }
    }

    private static class WriterSupplierFactory
    implements RecyclingSupplier.Factory<Writer> {
        private final String hostName;
        private final int port;
        private final SocketFactory socketFactory;

        WriterSupplierFactory(SocketFactory socketFactory, String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
            this.socketFactory = socketFactory;
        }

        @Override
        public Writer create() throws ObjectCreationException {
            Socket socket;
            try {
                socket = this.socketFactory.createSocket(this.hostName, this.port);
            }
            catch (IOException ex) {
                throw new ObjectCreationException(ex);
            }
            try {
                return new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), Charsets.UTF_8));
            }
            catch (IOException ex) {
                try {
                    socket.close();
                }
                catch (IOException ex1) {
                    ex1.addSuppressed(ex);
                    throw new ObjectCreationException(ex1);
                }
                throw new ObjectCreationException(ex);
            }
        }

        @Override
        public void dispose(Writer object) throws ObjectDisposeException {
            try {
                object.close();
            }
            catch (IOException ex) {
                throw new ObjectDisposeException(ex);
            }
        }

        @Override
        public boolean validate(Writer object, Exception e) {
            return e == null || !(Throwables.getRootCause((Throwable)e) instanceof IOException);
        }
    }
}

