/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Pair;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.io.Csv;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementAccumulator;
import org.spf4j.perf.MeasurementRecorder;
import org.spf4j.perf.MeasurementRecorderSource;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.MeasurementsSource;

@ThreadSafe
@SuppressFBWarnings(value={"PMB_INSTANCE_BASED_THREAD_LOCAL"})
public final class ScalableMeasurementRecorderSource
implements MeasurementRecorderSource,
MeasurementsSource,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ScalableMeasurementRecorderSource.class);
    private final Map<Thread, Map<Object, MeasurementAccumulator>> measurementProcessorMap;
    private final ThreadLocal<Map<Object, MeasurementAccumulator>> threadLocalMeasurementProcessorMap;
    private final ScheduledFuture<?> samplingFuture;
    private final MeasurementAccumulator processorTemplate;
    private final TObjectLongMap<MeasurementsInfo> tableIds;
    private final Persister persister;
    private final Runnable shutdownHook;

    ScalableMeasurementRecorderSource(MeasurementAccumulator processor, int sampleTimeMillis, MeasurementStore database) {
        if (sampleTimeMillis < 1000) {
            throw new IllegalArgumentException("sample time needs to be at least 1000 and not " + sampleTimeMillis);
        }
        this.processorTemplate = processor;
        this.measurementProcessorMap = new HashMap<Thread, Map<Object, MeasurementAccumulator>>();
        this.threadLocalMeasurementProcessorMap = new ThreadLocal<Map<Object, MeasurementAccumulator>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Map<Object, MeasurementAccumulator> initialValue() {
                HashMap<Object, MeasurementAccumulator> result = new HashMap<Object, MeasurementAccumulator>();
                Map map = ScalableMeasurementRecorderSource.this.measurementProcessorMap;
                synchronized (map) {
                    ScalableMeasurementRecorderSource.this.measurementProcessorMap.put(Thread.currentThread(), result);
                }
                return result;
            }
        };
        this.tableIds = new TObjectLongHashMap();
        this.persister = new Persister(database, sampleTimeMillis, processor);
        this.samplingFuture = DefaultScheduler.scheduleAllignedAtFixedRateMillis(this.persister, sampleTimeMillis);
        this.shutdownHook = this.closeOnShutdown();
    }

    private Runnable closeOnShutdown() {
        AbstractRunnable runnable = new AbstractRunnable(true){

            @Override
            public void doRun() {
                ScalableMeasurementRecorderSource.this.close();
            }
        };
        Runtime.queueHook(0, runnable);
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeasurementRecorder getRecorder(Object forWhat) {
        Map<Object, MeasurementAccumulator> recorders;
        Map<Object, MeasurementAccumulator> map = recorders = this.threadLocalMeasurementProcessorMap.get();
        synchronized (map) {
            MeasurementAccumulator result = recorders.get(forWhat);
            if (result == null) {
                result = this.processorTemplate.createLike(Pair.of(this.processorTemplate.getInfo().getMeasuredEntity(), forWhat));
                recorders.put(forWhat, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, MeasurementAccumulator> getEntitiesMeasurements() {
        HashMap<Object, MeasurementAccumulator> result = new HashMap<Object, MeasurementAccumulator>();
        Map<Thread, Map<Object, MeasurementAccumulator>> map = this.measurementProcessorMap;
        synchronized (map) {
            for (Map.Entry<Thread, Map<Object, MeasurementAccumulator>> entry : this.measurementProcessorMap.entrySet()) {
                Map<Object, MeasurementAccumulator> measurements;
                Map<Object, MeasurementAccumulator> map2 = measurements = entry.getValue();
                synchronized (map2) {
                    for (Map.Entry<Object, MeasurementAccumulator> lentry : measurements.entrySet()) {
                        Object what = lentry.getKey();
                        MeasurementAccumulator existingMeasurement = (MeasurementAccumulator)result.get(what);
                        existingMeasurement = existingMeasurement == null ? lentry.getValue().createClone() : existingMeasurement.aggregate(lentry.getValue().createClone());
                        result.put(what, existingMeasurement);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Map<Object, MeasurementAccumulator> getEntitiesMeasurementsAndReset() {
        HashMap<Object, MeasurementAccumulator> result = new HashMap<Object, MeasurementAccumulator>();
        Map<Thread, Map<Object, MeasurementAccumulator>> map = this.measurementProcessorMap;
        synchronized (map) {
            Iterator<Map.Entry<Thread, Map<Object, MeasurementAccumulator>>> iterator = this.measurementProcessorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map<Object, MeasurementAccumulator> measurements;
                Map.Entry<Thread, Map<Object, MeasurementAccumulator>> entry = iterator.next();
                Thread thread = entry.getKey();
                if (!thread.isAlive()) {
                    iterator.remove();
                }
                Map<Object, MeasurementAccumulator> map2 = measurements = entry.getValue();
                synchronized (map2) {
                    Iterator<Map.Entry<Object, MeasurementAccumulator>> iterator1 = measurements.entrySet().iterator();
                    while (iterator1.hasNext()) {
                        Map.Entry<Object, MeasurementAccumulator> lentry = iterator1.next();
                        Object what = lentry.getKey();
                        MeasurementAccumulator existingMeasurement = (MeasurementAccumulator)result.get(what);
                        if (existingMeasurement == null) {
                            existingMeasurement = lentry.getValue().reset();
                            if (existingMeasurement == null) {
                                iterator1.remove();
                                continue;
                            }
                            result.put(what, existingMeasurement);
                            continue;
                        }
                        MeasurementAccumulator vals = lentry.getValue().reset();
                        if (vals != null) {
                            existingMeasurement = existingMeasurement.aggregate(vals);
                            result.put(what, existingMeasurement);
                            continue;
                        }
                        iterator1.remove();
                    }
                }
            }
        }
        return result;
    }

    public void registerJmx() {
        Registry.export("org.spf4j.perf.recorders", this.processorTemplate.getInfo().getMeasuredEntity().toString(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void close() {
        MeasurementAccumulator measurementAccumulator = this.processorTemplate;
        synchronized (measurementAccumulator) {
            if (!this.samplingFuture.isCancelled()) {
                Runtime.removeQueuedShutdownHook(this.shutdownHook);
                this.samplingFuture.cancel(false);
                try {
                    this.persister.persist(false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                Registry.unregister("org.spf4j.perf.recorders", this.processorTemplate.getInfo().getMeasuredEntity().toString());
            }
        }
    }

    @JmxExport(description="measurements as csv")
    public String getMeasurementsAsString() {
        StringWriter sw = new StringWriter(128);
        Map<Object, MeasurementAccumulator> entitiesMeasurements = this.getEntitiesMeasurements();
        MeasurementsInfo info = this.processorTemplate.getInfo();
        try {
            Csv.writeCsvRow2(sw, "Measured", info.getMeasurementNames());
            Csv.writeCsvRow2(sw, "string", info.getMeasurementUnits());
            for (Map.Entry<Object, MeasurementAccumulator> entry : entitiesMeasurements.entrySet()) {
                Csv.writeCsvElement(entry.getKey().toString(), sw);
                sw.write(44);
                long[] measurements = entry.getValue().get();
                if (measurements == null) continue;
                Csv.writeCsvRow((Appendable)sw, measurements);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    @JmxExport
    public void clear() {
        this.getEntitiesMeasurementsAndReset();
    }

    public String toString() {
        return "ScalableMeasurementRecorderSource{measurementProcessorMap=" + this.measurementProcessorMap + ", threadLocalMeasurementProcessorMap=" + this.threadLocalMeasurementProcessorMap + ", samplingFuture=" + this.samplingFuture + ", processorTemplate=" + this.processorTemplate + ", tableIds=" + this.tableIds + ", persister=" + this.persister + ", shutdownHook=" + this.shutdownHook + '}';
    }

    private class Persister
    extends AbstractRunnable {
        private final MeasurementStore database;
        private final int sampleTimeMillis;
        private final MeasurementAccumulator processor;
        private volatile long lastRun;

        Persister(MeasurementStore database, int sampleTimeMillis, MeasurementAccumulator processor) {
            super(true);
            this.lastRun = 0L;
            this.database = database;
            this.sampleTimeMillis = sampleTimeMillis;
            this.processor = processor;
        }

        @Override
        public void doRun() throws IOException {
            this.persist(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void persist(boolean warn) throws IOException {
            long currentTime = System.currentTimeMillis();
            if (currentTime > this.lastRun) {
                this.lastRun = currentTime;
                for (MeasurementAccumulator m : ScalableMeasurementRecorderSource.this.getEntitiesMeasurementsAndReset().values()) {
                    long tableId;
                    MeasurementsInfo info = m.getInfo();
                    TObjectLongMap tObjectLongMap = ScalableMeasurementRecorderSource.this.tableIds;
                    synchronized (tObjectLongMap) {
                        tableId = ScalableMeasurementRecorderSource.this.tableIds.get((Object)info);
                        if (tableId == 0L) {
                            tableId = this.database.alocateMeasurements(info, this.sampleTimeMillis);
                            ScalableMeasurementRecorderSource.this.tableIds.put((Object)info, tableId);
                        }
                    }
                    long[] data = m.getThenReset();
                    if (data == null) continue;
                    this.database.saveMeasurements(tableId, currentTime, data);
                }
            } else if (warn) {
                LOG.warn("Last measurement recording for {} was at {} current run is {}, something is wrong", new Object[]{this.processor.getInfo(), this.lastRun, currentTime});
            }
        }
    }
}

