/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.io.Csv;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;
import org.spf4j.perf.MeasurementAccumulator;
import org.spf4j.perf.MeasurementStore;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.AbstractMeasurementAccumulator;

@ThreadSafe
@SuppressFBWarnings(value={"PMB_INSTANCE_BASED_THREAD_LOCAL"})
public final class ScalableMeasurementRecorder
extends AbstractMeasurementAccumulator {
    private static final Logger LOG = LoggerFactory.getLogger(ScalableMeasurementRecorder.class);
    private final Map<Thread, MeasurementAccumulator> threadLocalRecorders;
    private final ThreadLocal<MeasurementAccumulator> threadLocalRecorder;
    private final ScheduledFuture<?> samplingFuture;
    private final MeasurementAccumulator processorTemplate;
    private final Persister persister;
    private final Runnable shutdownHook;

    ScalableMeasurementRecorder(final MeasurementAccumulator processor, int sampleTimeMillis, MeasurementStore measurementStore) {
        long tableId;
        if (sampleTimeMillis < 1000) {
            throw new IllegalArgumentException("sample time needs to be at least 1000 and not " + sampleTimeMillis);
        }
        this.threadLocalRecorders = new HashMap<Thread, MeasurementAccumulator>();
        this.processorTemplate = processor;
        this.threadLocalRecorder = new ThreadLocal<MeasurementAccumulator>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected MeasurementAccumulator initialValue() {
                MeasurementAccumulator result = processor.createClone();
                Map map = ScalableMeasurementRecorder.this.threadLocalRecorders;
                synchronized (map) {
                    ScalableMeasurementRecorder.this.threadLocalRecorders.put(Thread.currentThread(), result);
                }
                return result;
            }
        };
        try {
            tableId = measurementStore.alocateMeasurements(processor.getInfo(), sampleTimeMillis);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.persister = new Persister(measurementStore, tableId, processor);
        this.samplingFuture = DefaultScheduler.scheduleAllignedAtFixedRateMillis(this.persister, sampleTimeMillis);
        this.shutdownHook = this.closeOnShutdown();
    }

    private Runnable closeOnShutdown() {
        AbstractRunnable runnable = new AbstractRunnable(true){

            @Override
            public void doRun() {
                ScalableMeasurementRecorder.this.close();
            }
        };
        Runtime.queueHook(0, runnable);
        return runnable;
    }

    @Override
    public void record(long measurement) {
        this.threadLocalRecorder.get().record(measurement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] get() {
        MeasurementAccumulator result = null;
        Map<Thread, MeasurementAccumulator> map = this.threadLocalRecorders;
        synchronized (map) {
            for (Map.Entry<Thread, MeasurementAccumulator> entry : this.threadLocalRecorders.entrySet()) {
                MeasurementAccumulator measurements = entry.getValue().createClone();
                if (result == null) {
                    result = measurements;
                    continue;
                }
                result = result.aggregate(measurements);
            }
        }
        return result == null ? null : result.get();
    }

    @JmxExport(description="measurements as csv")
    public String getMeasurementsAsString() {
        StringWriter sw = new StringWriter(128);
        MeasurementsInfo info = this.getInfo();
        try {
            Csv.writeCsvRow((Appendable)sw, info.getMeasurementNames());
            Csv.writeCsvRow((Appendable)sw, info.getMeasurementUnits());
            long[] values = this.get();
            if (values != null) {
                Csv.writeCsvRow((Appendable)sw, values);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sw.toString();
    }

    @JmxExport
    public void clear() {
        this.getThenReset();
    }

    @Override
    public MeasurementAccumulator aggregate(MeasurementAccumulator mSource) {
        throw new UnsupportedOperationException("Aggregating Scalable Recorders not supported");
    }

    @Override
    public MeasurementAccumulator createClone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void registerJmx() {
        Registry.export("org.spf4j.perf.recorders", this.processorTemplate.getInfo().getMeasuredEntity().toString(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public void close() {
        MeasurementAccumulator measurementAccumulator = this.processorTemplate;
        synchronized (measurementAccumulator) {
            if (!this.samplingFuture.isCancelled()) {
                Runtime.removeQueuedShutdownHook(this.shutdownHook);
                this.samplingFuture.cancel(false);
                try {
                    this.persister.persist(false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                Registry.unregister("org.spf4j.perf.recorders", this.processorTemplate.getInfo().getMeasuredEntity().toString());
            }
        }
    }

    public String toString() {
        return "ScalableMeasurementRecorder{threadLocalRecorders=" + this.threadLocalRecorders + ", processorTemplate=" + this.processorTemplate + '}';
    }

    @Override
    public MeasurementAccumulator createLike(Object entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MeasurementsInfo getInfo() {
        return this.processorTemplate.getInfo();
    }

    @Override
    public MeasurementAccumulator reset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getThenReset() {
        MeasurementAccumulator result = null;
        Map<Thread, MeasurementAccumulator> map = this.threadLocalRecorders;
        synchronized (map) {
            Iterator<Map.Entry<Thread, MeasurementAccumulator>> iterator = this.threadLocalRecorders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Thread, MeasurementAccumulator> entry = iterator.next();
                Thread t = entry.getKey();
                if (!t.isAlive()) {
                    iterator.remove();
                }
                MeasurementAccumulator measurements = entry.getValue().reset();
                if (result == null) {
                    result = measurements;
                    continue;
                }
                if (measurements == null) continue;
                result = result.aggregate(measurements);
            }
        }
        return result == null ? null : result.get();
    }

    private class Persister
    extends AbstractRunnable {
        private final MeasurementStore measurementStore;
        private final long tableId;
        private final MeasurementAccumulator processor;
        private volatile long lastRun;

        Persister(MeasurementStore measurementStore, long tableId, MeasurementAccumulator processor) {
            super(true);
            this.lastRun = 0L;
            this.measurementStore = measurementStore;
            this.tableId = tableId;
            this.processor = processor;
        }

        @Override
        public void doRun() throws IOException {
            this.persist(true);
        }

        public void persist(boolean warn) throws IOException {
            long currentTime = System.currentTimeMillis();
            if (currentTime > this.lastRun) {
                this.lastRun = currentTime;
                long[] measurements = ScalableMeasurementRecorder.this.getThenReset();
                if (measurements != null) {
                    this.measurementStore.saveMeasurements(this.tableId, currentTime, measurements);
                }
            } else if (warn) {
                LOG.warn("Last measurement recording for {} was at {} current run is {}, something is wrong", new Object[]{this.processor.getInfo(), this.lastRun, currentTime});
            }
        }
    }
}

