/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.spf4j.perf.MeasurementAccumulator;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.AbstractMeasurementAccumulator;
import org.spf4j.perf.impl.MeasurementsInfoImpl;

public final class MinMaxAvgAccumulator
extends AbstractMeasurementAccumulator {
    private long counter;
    private long total;
    private long min;
    private long max;
    private final MeasurementsInfo info;
    private static final String[] MEASUREMENTS = new String[]{"count", "total", "min", "max"};

    private MinMaxAvgAccumulator(Object measuredEntity, String description, String unitOfMeasurement, long counter, long total, long min, long max) {
        this.info = new MeasurementsInfoImpl(measuredEntity, description, MEASUREMENTS, new String[]{"count", unitOfMeasurement, unitOfMeasurement, unitOfMeasurement});
        this.counter = counter;
        this.total = total;
        this.min = min;
        this.max = max;
    }

    public MinMaxAvgAccumulator(Object measuredEntity, String description, String unitOfMeasurement) {
        this(measuredEntity, description, unitOfMeasurement, 0L, 0L, Long.MAX_VALUE, Long.MIN_VALUE);
    }

    public String getUnitOfMeasurement() {
        return this.info.getMeasurementUnit(1);
    }

    @Override
    public synchronized void record(long measurement) {
        this.total += measurement;
        ++this.counter;
        if (measurement < this.min) {
            this.min = measurement;
        }
        if (measurement > this.max) {
            this.max = measurement;
        }
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public synchronized long[] get() {
        if (this.counter == 0L) {
            return null;
        }
        return new long[]{this.counter, this.total, this.min, this.max};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX", "NOS_NON_OWNED_SYNCHRONIZATION"})
    public MeasurementAccumulator aggregate(MeasurementAccumulator mSource) {
        if (mSource instanceof MinMaxAvgAccumulator) {
            MinMaxAvgAccumulator other = (MinMaxAvgAccumulator)mSource;
            long[] measurements = other.get();
            if (measurements != null) {
                MinMaxAvgAccumulator minMaxAvgAccumulator = this;
                synchronized (minMaxAvgAccumulator) {
                    return new MinMaxAvgAccumulator(this.info.getMeasuredEntity(), this.info.getDescription(), this.getUnitOfMeasurement(), this.counter + measurements[0], this.total + measurements[1], Math.min(this.min, measurements[2]), Math.max(this.max, measurements[3]));
                }
            }
            return this.createClone();
        }
        throw new IllegalArgumentException("Cannot aggregate " + this + " with " + mSource);
    }

    @Override
    public synchronized MinMaxAvgAccumulator createClone() {
        return new MinMaxAvgAccumulator(this.info.getMeasuredEntity(), this.info.getDescription(), this.getUnitOfMeasurement(), this.counter, this.total, this.min, this.max);
    }

    @Override
    public MeasurementAccumulator createLike(Object entity) {
        return new MinMaxAvgAccumulator(entity, this.info.getDescription(), this.getUnitOfMeasurement());
    }

    @Override
    public MeasurementsInfo getInfo() {
        return this.info;
    }

    @Override
    public synchronized MinMaxAvgAccumulator reset() {
        if (this.counter == 0L) {
            return null;
        }
        MinMaxAvgAccumulator result = this.createClone();
        this.counter = 0L;
        this.total = 0L;
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        return result;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public long[] getThenReset() {
        MinMaxAvgAccumulator vals = this.reset();
        if (vals == null) {
            return null;
        }
        return vals.get();
    }

    public String toString() {
        return "MinMaxAvgAccumulator{counter=" + this.counter + ", total=" + this.total + ", min=" + this.min + ", max=" + this.max + ", info=" + this.info + '}';
    }
}

