/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.net;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.ThreadLocalRandom;
import org.spf4j.base.Callables;
import org.spf4j.net.Timing;

public final class SntpClient {
    private static final int ORIGINATE_TIME_OFFSET = 24;
    private static final int RECEIVE_TIME_OFFSET = 32;
    private static final int TRANSMIT_TIME_OFFSET = 40;
    private static final int NTP_PACKET_SIZE = 48;
    private static final int NTP_PORT = 123;
    private static final int NTP_MODE_CLIENT = 3;
    private static final int NTP_VERSION = 3;
    private static final long OFFSET_1900_TO_1970 = 2208988800L;
    private static final int MAX_SOCKET_TIMEOUT = 1000;

    private SntpClient() {
    }

    public static Timing requestTimeHA(int timeoutMillis, String ... hosts) throws IOException, InterruptedException {
        return SntpClient.requestTimeHA(timeoutMillis, 1000, hosts);
    }

    @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION"})
    public static Timing requestTimeHA(int timeoutMillis, final int ntpResponseTimeout, final String ... hosts) throws IOException, InterruptedException {
        return Callables.executeWithRetry(new Callables.TimeoutCallable<Timing, IOException>(timeoutMillis){
            private int i;
            {
                super(timeoutMillis);
                this.i = 0;
            }

            @Override
            @SuppressFBWarnings(value={"BED_BOGUS_EXCEPTION_DECLARATION"})
            public Timing call(long deadline) throws IOException {
                int hostIdx = Math.abs(this.i++) % hosts.length;
                return SntpClient.requestTime(hosts[hostIdx], Math.min((int)(deadline - System.currentTimeMillis()), ntpResponseTimeout));
            }
        }, 3, 1000);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static Timing requestTime(String host, int timeoutMillis) throws IOException {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(timeoutMillis);
            InetAddress address = InetAddress.getByName(host);
            byte[] buffer = new byte[48];
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, 123);
            buffer[0] = 27;
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            long requestTicks = System.nanoTime() / 1000000L;
            long requestTime = System.currentTimeMillis();
            SntpClient.writeTimeStamp(buffer, 40, requestTime);
            socket.send(request);
            socket.receive(response);
            long responseTicks = System.nanoTime() / 1000000L;
            long responseTime = requestTime + (responseTicks - requestTicks);
            long originateTime = SntpClient.readTimeStamp(buffer, 24);
            long receiveTime = SntpClient.readTimeStamp(buffer, 32);
            long transmitTime = SntpClient.readTimeStamp(buffer, 40);
            long roundTripTime = responseTicks - requestTicks - (transmitTime - receiveTime);
            long clockOffset = (receiveTime - originateTime + (transmitTime - responseTime)) / 2L;
            Timing timing = new Timing(responseTime + clockOffset, responseTicks, roundTripTime);
            return timing;
        }
    }

    private static long read32(byte[] buffer, int offset) {
        int b0 = buffer[offset];
        int b1 = buffer[offset + 1];
        int b2 = buffer[offset + 2];
        int b3 = buffer[offset + 3];
        int i0 = (b0 & 0x80) == 128 ? (b0 & 0x7F) + 128 : b0;
        int i1 = (b1 & 0x80) == 128 ? (b1 & 0x7F) + 128 : b1;
        int i2 = (b2 & 0x80) == 128 ? (b2 & 0x7F) + 128 : b2;
        int i3 = (b3 & 0x80) == 128 ? (b3 & 0x7F) + 128 : b3;
        return ((long)i0 << 24) + ((long)i1 << 16) + ((long)i2 << 8) + (long)i3;
    }

    private static long readTimeStamp(byte[] buffer, int offset) {
        long seconds = SntpClient.read32(buffer, offset);
        long fraction = SntpClient.read32(buffer, offset + 4);
        return (seconds - 2208988800L) * 1000L + fraction * 1000L / 0x100000000L;
    }

    private static void writeTimeStamp(byte[] buffer, int poffset, long time) {
        int offset = poffset;
        long seconds = time / 1000L;
        long milliseconds = time - seconds * 1000L;
        buffer[offset++] = (byte)((seconds += 2208988800L) >> 24);
        buffer[offset++] = (byte)(seconds >> 16);
        buffer[offset++] = (byte)(seconds >> 8);
        buffer[offset++] = (byte)seconds;
        long fraction = milliseconds * 0x100000000L / 1000L;
        buffer[offset++] = (byte)(fraction >> 24);
        buffer[offset++] = (byte)(fraction >> 16);
        buffer[offset++] = (byte)(fraction >> 8);
        buffer[offset] = (byte)(ThreadLocalRandom.current().nextInt() % 256);
    }
}

