/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.spf4j.base.Strings;
import org.spf4j.jmx.ExportedOperation;
import org.spf4j.jmx.ExportedOperationImpl;
import org.spf4j.jmx.ExportedValue;
import org.spf4j.jmx.ExportedValueImpl;
import org.spf4j.jmx.ExportedValuesMBean;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.MapExportedValue;

public final class Registry {
    private static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private static final Map<ObjectName, Object> REGISTERED = new HashMap<ObjectName, Object>();

    private Registry() {
    }

    public static synchronized Object registerMBean(ObjectName objectName, Object mbean) {
        Object replaced = null;
        if (MBEAN_SERVER.isRegistered(objectName)) {
            try {
                replaced = REGISTERED.remove(objectName);
                MBEAN_SERVER.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            MBEAN_SERVER.registerMBean(mbean, objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException ex) {
            throw new RuntimeException(ex);
        }
        REGISTERED.put(objectName, mbean);
        return replaced;
    }

    public static synchronized Object getRegistered(ObjectName objectName) {
        return REGISTERED.get(objectName);
    }

    public static synchronized Object getRegistered(String domain, String name) {
        return Registry.getRegistered(ExportedValuesMBean.createObjectName(domain, name));
    }

    public static Object registerMBean(String domain, String name, Object object) {
        return Registry.registerMBean(ExportedValuesMBean.createObjectName(domain, name), object);
    }

    @Nullable
    public static Object unregister(Object object) {
        Class<?> aClass = object.getClass();
        return Registry.unregister(aClass.getPackage().getName(), aClass.getSimpleName());
    }

    @Nullable
    public static Object unregister(Class<?> object) {
        return Registry.unregister(object.getPackage().getName(), object.getSimpleName());
    }

    @Nullable
    public static Object unregister(String packageName, String mbeanName) {
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        return Registry.unregister(objectName);
    }

    @Nullable
    public static synchronized Object unregister(ObjectName objectName) {
        Object result = null;
        if (MBEAN_SERVER.isRegistered(objectName)) {
            try {
                result = REGISTERED.remove(objectName);
                MBEAN_SERVER.unregisterMBean(objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    public static ExportedValuesMBean export(Object object) {
        Class<?> aClass = object.getClass();
        return Registry.export(aClass.getPackage().getName(), aClass.getSimpleName(), object);
    }

    public static ExportedValuesMBean export(Class<?> object) {
        return Registry.export(object.getPackage().getName(), object.getSimpleName(), object);
    }

    public static synchronized ExportedValuesMBean export(String packageName, String mbeanName, Object ... objects) {
        return Registry.export(packageName, mbeanName, (Map<String, Object>)null, objects);
    }

    @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER"})
    public static synchronized ExportedValuesMBean export(String packageName, String mbeanName, Properties attributes, Object ... objects) {
        return Registry.export(packageName, mbeanName, (Map<String, Object>)attributes, objects);
    }

    public static synchronized ExportedValuesMBean export(String packageName, String mbeanName, Map<String, Object> attributes, Object ... objects) {
        ObjectName objectName = ExportedValuesMBean.createObjectName(packageName, mbeanName);
        ExportedValuesMBean existing = (ExportedValuesMBean)Registry.unregister(objectName);
        HashMap<String, ExportedValue> exportedAttributes = new HashMap<String, ExportedValue>();
        if (attributes != null) {
            for (String string : attributes.keySet()) {
                exportedAttributes.put(string, new MapExportedValue(attributes, null, string));
            }
        }
        HashMap<String, ExportedOperationImpl> exportedOps = new HashMap<String, ExportedOperationImpl>();
        for (Object object : objects) {
            if (object instanceof Class) {
                for (Method method : ((Class)object).getMethods()) {
                    JmxExport annot;
                    if (method.isSynthetic() || !Modifier.isStatic(method.getModifiers()) || (annot = method.getAnnotation(JmxExport.class)) == null) continue;
                    Registry.exportMethod(method, null, exportedAttributes, exportedOps, annot);
                }
                continue;
            }
            Class<?> oClass = object.getClass();
            for (Method method : oClass.getMethods()) {
                JmxExport annot;
                if (method.isSynthetic() || (annot = method.getAnnotation(JmxExport.class)) == null) continue;
                Registry.exportMethod(method, object, exportedAttributes, exportedOps, annot);
            }
        }
        if (exportedAttributes.isEmpty() && exportedOps.isEmpty()) {
            return null;
        }
        ExportedValue[] exportedValueArray = new ExportedValue[exportedAttributes.size()];
        int i = 0;
        for (ExportedValue expVal : exportedAttributes.values()) {
            if (expVal instanceof ExportedValueImpl && !((ExportedValueImpl)expVal).isValid()) {
                throw new IllegalArgumentException("If setter is exported, getter must be exported as well " + expVal);
            }
            exportedValueArray[i++] = expVal;
        }
        ExportedValuesMBean mbean = existing == null ? new ExportedValuesMBean(objectName, exportedValueArray, exportedOps.values().toArray(new ExportedOperation[exportedOps.size()])) : new ExportedValuesMBean(existing, exportedValueArray, exportedOps.values().toArray(new ExportedOperation[exportedOps.size()]));
        Registry.registerMBean(mbean.getObjectName(), mbean);
        return mbean;
    }

    private static void exportMethod(Method method, @Nullable Object object, Map<String, ExportedValue> exportedAttributes, Map<String, ExportedOperationImpl> exportedOps, JmxExport annot) {
        method.setAccessible(true);
        String methodName = method.getName();
        int nrParams = method.getParameterTypes().length;
        if (nrParams == 0 && methodName.startsWith("get")) {
            String valueName = methodName.substring("get".length());
            valueName = Strings.withFirstCharLower(valueName);
            Registry.addGetter(valueName, exportedAttributes, annot, method, object);
        } else if (nrParams == 0 && methodName.startsWith("is")) {
            String valueName = methodName.substring("is".length());
            valueName = Strings.withFirstCharLower(valueName);
            Registry.addGetter(valueName, exportedAttributes, annot, method, object);
        } else if (nrParams == 1 && methodName.startsWith("set")) {
            Registry.addSetter(methodName, exportedAttributes, method, object, annot);
        } else {
            ExportedOperationImpl existing;
            String opName = methodName;
            String nameOverwrite = annot.value();
            if (!"".equals(nameOverwrite)) {
                opName = nameOverwrite;
            }
            if ((existing = exportedOps.put(opName, new ExportedOperationImpl(opName, annot.description(), method, object))) != null) {
                throw new IllegalArgumentException("exporting operations with same name not supported: " + opName);
            }
        }
    }

    private static void addSetter(String methodName, Map<String, ExportedValue> exportedAttributes, Method method, Object object, JmxExport annot) {
        String valueName;
        String customName = annot.value();
        if ("".equals(customName)) {
            valueName = methodName.substring("set".length());
            valueName = Strings.withFirstCharLower(valueName);
        } else {
            valueName = customName;
        }
        ExportedValueImpl existing = (ExportedValueImpl)exportedAttributes.get(valueName);
        if (existing == null) {
            existing = new ExportedValueImpl(valueName, null, null, method, object, method.getParameterTypes()[0]);
        } else {
            if (existing.getValueClass() != method.getParameterTypes()[0]) {
                throw new IllegalArgumentException("Getter and setter icorrectly defined " + existing + ' ' + method);
            }
            existing = existing.withSetter(method);
        }
        exportedAttributes.put(valueName, existing);
    }

    private static void addGetter(String pvalueName, Map<String, ExportedValue> exported, JmxExport annot, Method method, Object object) {
        String customName = annot.value();
        String valueName = "".equals(customName) ? pvalueName : customName;
        ExportedValueImpl existing = (ExportedValueImpl)exported.get(valueName);
        if (existing == null) {
            existing = new ExportedValueImpl(valueName, annot.description(), method, null, object, method.getReturnType());
        } else {
            if (existing.getValueClass() != method.getReturnType()) {
                throw new IllegalArgumentException("Getter and setter icorrectly defined " + existing + ' ' + method);
            }
            existing = existing.withGetter(method, annot.description());
        }
        exported.put(valueName, existing);
    }
}

