/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import com.google.common.base.Converter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.openmbean.OpenType;
import org.spf4j.base.Runtime;

@SuppressFBWarnings(value={"HE_INHERITS_EQUALS_USE_HASHCODE"})
public final class OpenTypeConverter {
    private OpenTypeConverter() {
    }

    private static Object getMXBeanMapping(Class<?> type) {
        try {
            return JMX17P.MAPPING_FOR_TYPE.invoke(JMX17P.DEFAULT_MAPPING_FACTORY, type, JMX17P.DEFAULT_MAPPING_FACTORY);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static OpenType<?> getOpenType(Class<?> type) {
        if (Runtime.JAVA_PLATFORM.ordinal() >= Runtime.Version.V1_7.ordinal()) {
            try {
                return (OpenType)JMX17P.MAPPING_GET_OPEN_TYPE.invoke(OpenTypeConverter.getMXBeanMapping(type), new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new RuntimeException("Unsupported JVM runtime" + (Object)((Object)Runtime.JAVA_PLATFORM));
    }

    public static Converter<Object, Object> getConverter(Class<?> type) {
        if (Runtime.JAVA_PLATFORM.ordinal() >= Runtime.Version.V1_7.ordinal()) {
            final Object mapping = OpenTypeConverter.getMXBeanMapping(type);
            return new Converter<Object, Object>(){

                protected Object doForward(Object a) {
                    try {
                        return JMX17P.MAPPING_FROM_OPEN_VALUE.invoke(mapping, a);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                }

                protected Object doBackward(Object b) {
                    try {
                        return JMX17P.MAPPING_TO_OPEN_VALUE.invoke(mapping, b);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        }
        throw new RuntimeException("Unsupported JVM runtime" + (Object)((Object)Runtime.JAVA_PLATFORM));
    }

    private static class JMX17P {
        private static final Object DEFAULT_MAPPING_FACTORY;
        private static final Method MAPPING_FOR_TYPE;
        private static final Method MAPPING_GET_OPEN_TYPE;
        private static final Method MAPPING_FROM_OPEN_VALUE;
        private static final Method MAPPING_TO_OPEN_VALUE;

        private JMX17P() {
        }

        static {
            try {
                Class<?> mxBeanMappingFactoryClass = Class.forName("com.sun.jmx.mbeanserver.MXBeanMappingFactory");
                DEFAULT_MAPPING_FACTORY = mxBeanMappingFactoryClass.getField("DEFAULT").get(null);
                MAPPING_FOR_TYPE = mxBeanMappingFactoryClass.getMethod("mappingForType", Type.class, mxBeanMappingFactoryClass);
                Class<?> mxBeanMappingClass = Class.forName("com.sun.jmx.mbeanserver.MXBeanMapping");
                MAPPING_GET_OPEN_TYPE = mxBeanMappingClass.getMethod("getOpenType", new Class[0]);
                MAPPING_FROM_OPEN_VALUE = mxBeanMappingClass.getDeclaredMethod("fromOpenValue", Object.class);
                MAPPING_TO_OPEN_VALUE = mxBeanMappingClass.getDeclaredMethod("toOpenValue", Object.class);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        MAPPING_FOR_TYPE.setAccessible(true);
                        MAPPING_GET_OPEN_TYPE.setAccessible(true);
                        MAPPING_FROM_OPEN_VALUE.setAccessible(true);
                        MAPPING_TO_OPEN_VALUE.setAccessible(true);
                        return null;
                    }
                });
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

