/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import java.util.Map;
import org.spf4j.jmx.ExportedValue;

public final class MapExportedValue
implements ExportedValue {
    private final Map<String, Object> map;
    private final Map<String, String> descriptions;
    private final String name;

    public MapExportedValue(Map<String, Object> map, Map<String, String> descriptions, String name) {
        this.map = map;
        this.descriptions = descriptions;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.descriptions != null) {
            return this.descriptions.get(this.name);
        }
        return "";
    }

    public Object get() {
        return this.map.get(this.name);
    }

    public void set(Object value) {
        this.map.put(this.name, value);
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    public Class getValueClass() {
        Object obj = this.map.get(this.name);
        if (obj == null) {
            return String.class;
        }
        return obj.getClass();
    }

    public String toString() {
        return "MapExportedValue{map=" + this.map + ", descriptions=" + this.descriptions + ", name=" + this.name + '}';
    }
}

