/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import com.google.common.base.Converter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.InvalidAttributeValueException;
import org.spf4j.jmx.ExportedValue;
import org.spf4j.jmx.OpenTypeConverter;

class ExportedValueImpl
implements ExportedValue<Object> {
    private final String name;
    private final String description;
    private final Method getMethod;
    private final Method setMethod;
    private final Object object;
    private final Class<?> valueClass;
    private final Converter<Object, Object> converter;

    ExportedValueImpl(@Nonnull String name, @Nullable String description, @Nullable Method getMethod, @Nullable Method setMethod, @Nullable Object object, @Nonnull Class<?> valueClass) {
        this.name = name;
        this.description = description;
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        this.object = object;
        this.valueClass = valueClass;
        this.converter = valueClass == Boolean.class || valueClass == String.class || valueClass.isPrimitive() || Number.class.isAssignableFrom(valueClass) ? null : OpenTypeConverter.getConverter(valueClass);
    }

    public ExportedValueImpl withSetter(@Nonnull Method psetMethod) {
        if (this.setMethod != null) {
            throw new IllegalArgumentException("duplicate value registration attemted " + this.setMethod + ", " + psetMethod);
        }
        return new ExportedValueImpl(this.name, this.description, this.getMethod, psetMethod, this.object, this.valueClass);
    }

    public ExportedValueImpl withGetter(@Nonnull Method pgetMethod, @Nonnull String pdescription) {
        if (this.getMethod != null) {
            throw new IllegalArgumentException("duplicate value registration attemted " + this.getMethod + ", " + pgetMethod);
        }
        return new ExportedValueImpl(this.name, pdescription, pgetMethod, this.setMethod, this.object, this.valueClass);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_NO_CHECKED"})
    public Object get() {
        try {
            if (this.converter != null) {
                return this.converter.reverse().convert(this.getMethod.invoke(this.object, new Object[0]));
            }
            return this.getMethod.invoke(this.object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    @SuppressFBWarnings(value={"EXS_EXCEPTION_SOFTENING_HAS_CHECKED"})
    public void set(Object value) throws InvalidAttributeValueException {
        if (this.setMethod == null) {
            throw new InvalidAttributeValueException(this.name + " is a read only attribute ");
        }
        try {
            if (this.converter != null) {
                this.setMethod.invoke(this.object, this.converter.convert(value));
            } else {
                this.setMethod.invoke(this.object, value);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isWriteable() {
        return this.setMethod != null;
    }

    @Override
    public Class<? extends Object> getValueClass() {
        return this.valueClass;
    }

    public boolean isValid() {
        return this.getMethod != null;
    }

    public String toString() {
        return "ExportedValueImpl{name=" + this.name + ", description=" + this.description + ", getMethod=" + this.getMethod + ", setMethod=" + this.setMethod + ", object=" + this.object + ", valueClass=" + this.valueClass + '}';
    }
}

