/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.spf4j.jmx.ExportedValuesMBean;

@SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
public final class Client {
    private Client() {
    }

    public static Object getAttribute(@Nonnull String serviceUrl, @Nonnull String domain, @Nonnull String mbeanName, @Nonnull String attribName) throws IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException {
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        try (JMXConnector jmxc = JMXConnectorFactory.connect(url, null);){
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            Object object = mbsc.getAttribute(ExportedValuesMBean.createObjectName(domain, mbeanName), attribName);
            return object;
        }
    }

    public static void setAttribute(@Nonnull String serviceUrl, @Nonnull String domain, @Nonnull String mbeanName, @Nonnull String attribName, @Nonnull Object attribValue) throws IOException, InstanceNotFoundException, MBeanException, AttributeNotFoundException, ReflectionException, InvalidAttributeValueException {
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        try (JMXConnector jmxc = JMXConnectorFactory.connect(url, null);){
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            mbsc.setAttribute(ExportedValuesMBean.createObjectName(domain, mbeanName), new Attribute(attribName, attribValue));
        }
    }

    public static Object callOperation(@Nonnull String serviceUrl, @Nonnull String domain, @Nonnull String mbeanName, @Nonnull String operationName, Object ... parameters) throws IOException, InstanceNotFoundException, MBeanException, ReflectionException {
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        try (JMXConnector jmxc = JMXConnectorFactory.connect(url, null);){
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            Object object = mbsc.invoke(ExportedValuesMBean.createObjectName(domain, mbeanName), operationName, parameters, null);
            return object;
        }
    }
}

