/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import org.spf4j.ds.LinkedHashMapEx;
import org.spf4j.ds.LinkedMap;
import org.spf4j.ds.LinkedSet;

public final class LinkedHashSetEx<V>
extends AbstractSet<V>
implements LinkedSet<V> {
    private final LinkedMap<V, Object> map;
    private static final Object PRESENT = new Object();

    public LinkedHashSetEx() {
        this.map = new LinkedHashMapEx<V, Object>();
    }

    public LinkedHashSetEx(int capacity) {
        this.map = new LinkedHashMapEx<V, Object>(capacity);
    }

    @Override
    public Iterator<V> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public V getLastValue() {
        Map.Entry<V, Object> lastEntry = this.map.getLastEntry();
        if (lastEntry == null) {
            return null;
        }
        return lastEntry.getKey();
    }

    @Override
    public V pollLastValue() {
        Map.Entry<V, Object> lastEntry = this.map.pollLastEntry();
        if (lastEntry == null) {
            return null;
        }
        return lastEntry.getKey();
    }

    @Override
    public boolean add(V e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

