/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.spf4j.ds.LinkedMap;

public final class LinkedHashMapEx<K, V>
extends LinkedHashMap<K, V>
implements LinkedMap<K, V> {
    private static final Field TAIL = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            try {
                Field field = LinkedHashMap.class.getDeclaredField("tail");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException | SecurityException ex) {
                throw new RuntimeException(ex);
            }
        }
    });
    private static final long serialVersionUID = 1L;

    private Map.Entry<K, V> getTail() {
        try {
            return (Map.Entry)TAIL.get(this);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public LinkedHashMapEx() {
    }

    public LinkedHashMapEx(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public LinkedHashMapEx(int initialCapacity) {
        super(initialCapacity);
    }

    public LinkedHashMapEx(Map<? extends K, ? extends V> m) {
        super(m);
    }

    public LinkedHashMapEx(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
    }

    @Override
    @Nullable
    public Map.Entry<K, V> getLastEntry() {
        return this.getTail();
    }

    @Override
    @Nullable
    public Map.Entry<K, V> pollLastEntry() {
        Map.Entry<K, V> lastEntry = this.getTail();
        if (lastEntry != null) {
            this.remove(lastEntry.getKey());
        }
        return lastEntry;
    }
}

