/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.spf4j.concurrent.jdbc.JdbcSemaphore;
import org.spf4j.concurrent.jdbc.Semaphore;

public final class ProcessLimitedJdbcSemaphore
implements Semaphore {
    private final JdbcSemaphore jdbcSemaphore;
    private final java.util.concurrent.Semaphore semaphore;

    public ProcessLimitedJdbcSemaphore(JdbcSemaphore jdbcSemaphore, int maxProcessPermits) {
        this.jdbcSemaphore = jdbcSemaphore;
        this.semaphore = new java.util.concurrent.Semaphore(maxProcessPermits);
    }

    @Override
    public void acquire(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.semaphore.tryAcquire(timeout, unit)) {
            try {
                this.jdbcSemaphore.acquire(timeout, unit);
            }
            catch (InterruptedException | RuntimeException | TimeoutException e) {
                this.semaphore.release();
                throw e;
            }
        } else {
            throw new TimeoutException("Timeout out after " + timeout + ' ' + (Object)((Object)unit));
        }
    }

    @Override
    public void acquire(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.semaphore.tryAcquire(nrPermits, timeout, unit)) {
            try {
                this.jdbcSemaphore.acquire(nrPermits, timeout, unit);
            }
            catch (InterruptedException | RuntimeException | TimeoutException e) {
                this.semaphore.release();
                throw e;
            }
        } else {
            throw new TimeoutException("Timeout out after " + timeout + ' ' + (Object)((Object)unit));
        }
    }

    @Override
    public void release() {
        this.jdbcSemaphore.release();
        this.semaphore.release();
    }

    @Override
    public void release(int nrReservations) {
        this.jdbcSemaphore.release(nrReservations);
        this.semaphore.release();
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.semaphore.tryAcquire(timeout, unit)) {
            try {
                return this.jdbcSemaphore.tryAcquire(timeout, unit);
            }
            catch (InterruptedException | RuntimeException e) {
                this.semaphore.release();
                throw e;
            }
        }
        return false;
    }

    @Override
    public boolean tryAcquire(int nrPermits, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.semaphore.tryAcquire(nrPermits, timeout, unit)) {
            try {
                return this.jdbcSemaphore.tryAcquire(nrPermits, timeout, unit);
            }
            catch (InterruptedException | RuntimeException e) {
                this.semaphore.release();
                throw e;
            }
        }
        return false;
    }

    public String toString() {
        return "ProcessLimitedJdbcSemaphore{jdbcSemaphore=" + this.jdbcSemaphore + ", semaphore=" + this.semaphore + '}';
    }
}

