/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import java.io.Serializable;
import org.spf4j.jdbc.DbType;

public final class HeartBeatTableDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final String ownerColumn;
    private final String intervalColumn;
    private final String lastHeartbeatColumn;
    private final String currentTimeMillisFunc;
    public static final HeartBeatTableDesc DEFAULT = new HeartBeatTableDesc(System.getProperty("spf4j.jdbc.heartBeats.sql.tableName", "HEARTBEATS"), System.getProperty("spf4j.jdbc.heartBeats.sql.ownerColumn", "OWNER"), System.getProperty("spf4j.jdbc.heartBeats.sql.intervalMillisColumn", "INTERVAL_MILLIS"), System.getProperty("spf4j.jdbc.heartBeats.sql.lastHeartBeatMillisColumn", "LAST_HEARTBEAT_INSTANT_MILLIS"), System.getProperty("spf4j.jdbc.heartBeats.sql.currTsSqlFunction", HeartBeatTableDesc.getCurrTSSqlFn(DbType.DEFAULT)));

    public HeartBeatTableDesc(String tableName, String ownerColun, String intervalColumn, String lastHeartbeatColumn, String currentTimeMillisFunc) {
        this.tableName = tableName;
        this.ownerColumn = ownerColun;
        this.intervalColumn = intervalColumn;
        this.lastHeartbeatColumn = lastHeartbeatColumn;
        this.currentTimeMillisFunc = currentTimeMillisFunc;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOwnerColumn() {
        return this.ownerColumn;
    }

    public String getIntervalColumn() {
        return this.intervalColumn;
    }

    public String getLastHeartbeatColumn() {
        return this.lastHeartbeatColumn;
    }

    public String getCurrentTimeMillisFunc() {
        return this.currentTimeMillisFunc;
    }

    public String toString() {
        return "HeartbeatTableDesc{tableName=" + this.tableName + ", ownerColun=" + this.ownerColumn + ", intervalColumn=" + this.intervalColumn + ", lastHeartbeatColumn=" + this.lastHeartbeatColumn + '}';
    }

    public static String getCurrTSSqlFn(DbType dbType) throws ExceptionInInitializerError {
        switch (dbType) {
            case H2: {
                return "TIMESTAMPDIFF('MILLISECOND', timestamp '1970-01-01 00:00:00', CURRENT_TIMESTAMP())";
            }
            case ORACLE: {
                return "(SYSDATE - TO_DATE('01-01-1970 00:00:00', 'DD-MM-YYYY HH24:MI:SS')) * 24 * 3600000";
            }
            case MSSQL: {
                return "DATEDIFF(ms, '1970-01-01 00:00:00', GETUTCDATE())";
            }
            case POSTGRES: {
                return "extract(epoch FROM now()) * 1000";
            }
            case COCKROACH_DB: {
                return "extract(epoch_nanosecond from now()) / 1e6";
            }
        }
        throw new ExceptionInInitializerError("Database not supported");
    }
}

