/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.spf4j.base.Runtime;

public final class UnitQueuePU<T> {
    private final AtomicReference<T> value = new AtomicReference();
    private final Thread readerThread;
    private static final int SPIN_LIMITER = Integer.getInteger("spf4j.lifoTp.maxSpinning", Runtime.NR_PROCESSORS / 2);
    private static final Semaphore SPIN_LIMIT = new Semaphore(SPIN_LIMITER);

    public UnitQueuePU(Thread readerThread) {
        this.readerThread = readerThread;
    }

    public T poll() {
        T result = this.value.getAndSet(null);
        if (result != null) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public T poll(long timeoutNanos, long spinCount) throws InterruptedException {
        boolean tryAcquire;
        T result = this.poll();
        if (result != null) {
            return result;
        }
        if (spinCount > 0L && Runtime.NR_PROCESSORS > 1 && (tryAcquire = SPIN_LIMIT.tryAcquire())) {
            try {
                int i = 0;
                while ((long)i < spinCount) {
                    result = this.poll();
                    if (result != null) {
                        T t = result;
                        return t;
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    ++i;
                }
            }
            finally {
                SPIN_LIMIT.release();
            }
        }
        long deadlineNanos = System.nanoTime() + timeoutNanos;
        while ((result = this.value.getAndSet(null)) == null) {
            long to = deadlineNanos - System.nanoTime();
            if (to <= 0L) {
                return null;
            }
            LockSupport.parkNanos(to);
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
        return result;
    }

    public boolean offer(T offer) {
        boolean result = this.value.compareAndSet(null, offer);
        if (result) {
            LockSupport.unpark(this.readerThread);
        }
        return result;
    }

    public String toString() {
        return "UnitQueuePU{value=" + this.value + '}';
    }
}

