/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.MemorizedCallable;

@ParametersAreNonnullByDefault
public final class UnboundedLoadingCache<K, V>
implements LoadingCache<K, V> {
    private final ConcurrentMap<K, Callable<? extends V>> map;
    private final CacheLoader<K, V> loader;

    public UnboundedLoadingCache(int initialSize, CacheLoader<K, V> loader) {
        this(initialSize, 8, loader);
    }

    public UnboundedLoadingCache(int initialSize, int concurrency, CacheLoader<K, V> loader) {
        this.map = new ConcurrentHashMap<K, Callable<? extends V>>(initialSize, 0.75f, concurrency);
        this.loader = loader;
    }

    public V get(final K key) throws ExecutionException {
        MemorizedCallable newHolder;
        MemorizedCallable existingValHolder = (MemorizedCallable)this.map.get(key);
        if (existingValHolder == null && (existingValHolder = (Callable)this.map.putIfAbsent(key, newHolder = new MemorizedCallable(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return UnboundedLoadingCache.this.loader.load(key);
            }
        }))) == null) {
            existingValHolder = newHolder;
        }
        try {
            return existingValHolder.call();
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (K key : keys) {
            builder.put(key, this.get(key));
        }
        return builder.build();
    }

    public V apply(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null for " + this);
        }
        return this.getUnchecked(key);
    }

    public void refresh(K key) {
        this.getUnchecked(key);
    }

    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    public V getIfPresent(Object key) {
        Callable existingValHolder = (Callable)this.map.get(key);
        if (existingValHolder != null) {
            try {
                return existingValHolder.call();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        MemorizedCallable<V> newHolder;
        MemorizedCallable<V> existingValHolder = (MemorizedCallable<V>)this.map.get(key);
        if (existingValHolder == null && (existingValHolder = (Callable)this.map.putIfAbsent(key, newHolder = new MemorizedCallable<V>(valueLoader))) == null) {
            existingValHolder = newHolder;
        }
        try {
            return existingValHolder.call();
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object key : keys) {
            V val = this.getIfPresent(key);
            if (val == null) continue;
            builder.put(key, val);
        }
        return builder.build();
    }

    public void put(K key, final V value) {
        this.map.put(key, new Callable<V>(){

            @Override
            public V call() {
                return value;
            }
        });
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void invalidate(Object key) {
        this.map.remove(key);
    }

    public void invalidateAll(Iterable<?> keys) {
        for (Object key : keys) {
            this.invalidate(key);
        }
    }

    public void invalidateAll() {
        this.map.clear();
    }

    public long size() {
        return this.map.size();
    }

    public CacheStats stats() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void cleanUp() {
        this.map.clear();
    }

    public String toString() {
        return "UnboundedLoadingCache{map=" + this.map + ", loader=" + this.loader + '}';
    }
}

