/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.concurrent.RestartableService;
import org.spf4j.jmx.JmxExport;
import org.spf4j.jmx.Registry;

@Beta
public abstract class RestartableServiceImpl
implements RestartableService {
    private static final Logger LOG = LoggerFactory.getLogger(RestartableServiceImpl.class);
    private final Supplier<Service> supplier;
    private volatile Service guavaService;

    public RestartableServiceImpl(Supplier<Service> supplier) {
        this.supplier = supplier;
        this.guavaService = (Service)supplier.get();
    }

    public final void registerToJmx() {
        Registry.export(RestartableService.class.getName(), this.getServiceName(), this);
    }

    @JmxExport
    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public final synchronized Service startAsync() {
        Service svc = this.guavaService;
        Service.State state = svc.state();
        switch (state) {
            case NEW: {
                svc.startAsync();
                break;
            }
            case FAILED: {
                LOG.warn("Restarting a failed service", svc.failureCause());
                this.restart();
                break;
            }
            case TERMINATED: {
                this.restart();
                break;
            }
            default: {
                throw new IllegalStateException("Service is in invalid state " + state);
            }
        }
        return this;
    }

    private void restart() {
        Service newSvc;
        this.guavaService = newSvc = (Service)this.supplier.get();
        newSvc.startAsync();
    }

    @JmxExport
    public final boolean isRunning() {
        return this.guavaService.isRunning();
    }

    @JmxExport
    public final Service.State state() {
        return this.guavaService.state();
    }

    @JmxExport
    public final Service stopAsync() {
        this.guavaService.stopAsync();
        return this;
    }

    @JmxExport
    public final void awaitRunning() {
        this.guavaService.awaitRunning();
    }

    public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        this.guavaService.awaitRunning(timeout, unit);
    }

    @JmxExport
    public final void awaitTerminated() {
        this.guavaService.awaitTerminated();
    }

    public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        this.guavaService.awaitTerminated(timeout, unit);
    }

    @JmxExport
    public final Throwable failureCause() {
        return this.guavaService.failureCause();
    }

    public final void addListener(Service.Listener listener, Executor executor) {
        this.guavaService.addListener(listener, executor);
    }

    @Override
    public final void close() {
        this.guavaService.stopAsync().awaitTerminated();
        Registry.unregister(RestartableService.class.getName(), this.getServiceName());
    }

    public final String toString() {
        return this.getServiceName();
    }
}

