/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.AbstractExecutorService;
import org.spf4j.concurrent.LifoThreadPool;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;
import org.spf4j.concurrent.MutableLifoThreadPool;
import org.spf4j.concurrent.MutableLifoThreadPoolExecutorSQP;
import org.spf4j.concurrent.RejectedExecutionHandler;

public final class LifoThreadPoolBuilder {
    private String poolName = "Lifo Pool";
    private int coreSize = 0;
    private int maxSize;
    private int maxIdleTimeMillis = 60000;
    private Queue<Runnable> taskQueue;
    private int queueSizeLimit = 0;
    private boolean daemonThreads = false;
    private int spinLockCount = 1024;
    private RejectedExecutionHandler rejectionHandler = RejectedExecutionHandler.REJECT_EXCEPTION_EXEC_HANDLER;
    private int threadPriority = 5;
    private boolean mutable = false;
    private boolean jmxEnabled = false;

    private LifoThreadPoolBuilder() {
        this.maxSize = Short.MAX_VALUE;
        this.taskQueue = new ArrayDeque<Runnable>(256);
    }

    public static LifoThreadPoolBuilder newBuilder() {
        return new LifoThreadPoolBuilder();
    }

    public LifoThreadPoolBuilder withPoolName(String poolName) {
        this.poolName = poolName;
        return this;
    }

    public LifoThreadPoolBuilder withCoreSize(int coreSize) {
        this.coreSize = coreSize;
        return this;
    }

    public LifoThreadPoolBuilder withMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public LifoThreadPoolBuilder withMaxIdleTimeMillis(int maxIdleTimeMillis) {
        this.maxIdleTimeMillis = maxIdleTimeMillis;
        return this;
    }

    public LifoThreadPoolBuilder withTaskQueue(Queue<Runnable> taskQueue) {
        this.taskQueue = taskQueue;
        return this;
    }

    public LifoThreadPoolBuilder withQueueSizeLimit(int queueSizeLimit) {
        this.queueSizeLimit = queueSizeLimit;
        return this;
    }

    public LifoThreadPoolBuilder withDaemonThreads(boolean daemonThreads) {
        this.daemonThreads = daemonThreads;
        return this;
    }

    public LifoThreadPoolBuilder withSpinLockCount(int spinLockCount) {
        this.spinLockCount = spinLockCount;
        return this;
    }

    public LifoThreadPoolBuilder withRejectionHandler(RejectedExecutionHandler rejectionHandler) {
        this.rejectionHandler = rejectionHandler;
        return this;
    }

    public LifoThreadPoolBuilder withThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
        return this;
    }

    public LifoThreadPoolBuilder mutable() {
        this.mutable = true;
        return this;
    }

    public LifoThreadPoolBuilder enableJmx() {
        this.jmxEnabled = true;
        return this;
    }

    public LifoThreadPool build() {
        AbstractExecutorService result = this.mutable ? new MutableLifoThreadPoolExecutorSQP(this.poolName, this.coreSize, this.maxSize, this.maxIdleTimeMillis, this.taskQueue, this.queueSizeLimit, this.daemonThreads, this.spinLockCount, this.rejectionHandler, this.threadPriority) : new LifoThreadPoolExecutorSQP(this.poolName, this.coreSize, this.maxSize, this.maxIdleTimeMillis, this.taskQueue, this.queueSizeLimit, this.daemonThreads, this.spinLockCount, this.rejectionHandler, this.threadPriority);
        if (this.jmxEnabled) {
            result.exportJmx();
        }
        return result;
    }

    public MutableLifoThreadPool buildMutable() {
        MutableLifoThreadPoolExecutorSQP result = new MutableLifoThreadPoolExecutorSQP(this.poolName, this.coreSize, this.maxSize, this.maxIdleTimeMillis, this.taskQueue, this.queueSizeLimit, this.daemonThreads, this.spinLockCount, this.rejectionHandler, this.threadPriority);
        if (this.jmxEnabled) {
            result.exportJmx();
        }
        return result;
    }

    public String toString() {
        return "LifoThreadPoolBuilder{poolName=" + this.poolName + ", coreSize=" + this.coreSize + ", maxSize=" + this.maxSize + ", maxIdleTimeMillis=" + this.maxIdleTimeMillis + ", queueSizeLimit=" + this.queueSizeLimit + ", daemonThreads=" + this.daemonThreads + ", spinLockCount=" + this.spinLockCount + ", rejectionHandler=" + this.rejectionHandler + ", threadPriority=" + this.threadPriority + ", mutable=" + this.mutable + ", jmxEnabled=" + this.jmxEnabled + '}';
    }
}

