/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.concurrent.UpdateResult;

@ParametersAreNonnullByDefault
public final class Atomics {
    private Atomics() {
    }

    public static <T> UpdateResult<T> update(AtomicReference<T> ar, UnaryOperator<T> function) {
        Object newObj;
        T initial;
        do {
            if (Objects.equals(initial = ar.get(), newObj = function.apply(initial))) {
                return UpdateResult.same(initial);
            }
            if (initial != newObj) continue;
            throw new IllegalStateException("Function " + function + " is mutating " + initial + ", this is not allowed");
        } while (!ar.compareAndSet(initial, newObj));
        return UpdateResult.updated(newObj);
    }
}

