/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Objects;
import org.spf4j.base.Reflections;
import org.spf4j.ds.IdentityHashSet;

@ParametersAreNonnullByDefault
public final class Throwables {
    public static final int MAX_THROWABLE_CHAIN = Integer.getInteger("spf4j.throwables.defaultMaxSuppressChain", 200);
    private static final Field CAUSE_FIELD = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field causeField;
            try {
                causeField = Throwable.class.getDeclaredField("cause");
            }
            catch (NoSuchFieldException | SecurityException ex) {
                throw new RuntimeException(ex);
            }
            causeField.setAccessible(true);
            return causeField;
        }
    });
    private static final Field SUPPRESSED_FIELD = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field suppressedField;
            try {
                suppressedField = Throwable.class.getDeclaredField("suppressedExceptions");
            }
            catch (NoSuchFieldException | SecurityException ex) {
                Lazy.LOG.info("No access to suppressed Exceptions", (Throwable)ex);
                return null;
            }
            suppressedField.setAccessible(true);
            return suppressedField;
        }
    });
    private static final Detail DEFAULT_DETAIL = Detail.valueOf(System.getProperty("spf4j.throwables.defaultStackTraceDetail", "SHORT_PACKAGE"));
    public static final String SUPPRESSED_CAPTION = "Suppressed: ";
    public static final String CAUSE_CAPTION = "Caused by: ";
    private static volatile Predicate<Throwable> nrPredicate = new Predicate<Throwable>(){

        @Override
        @SuppressFBWarnings(value={"ITC_INHERITANCE_TYPE_CHECKING"})
        public boolean test(Throwable t) {
            String message;
            if (t instanceof Error && !(t instanceof StackOverflowError)) {
                return true;
            }
            return t instanceof IOException && (message = t.getMessage()) != null && message.contains("Too many open files");
        }
    };

    private Throwables() {
    }

    public static int getNrSuppressedExceptions(Throwable t) {
        try {
            List suppressedExceptions = (List)SUPPRESSED_FIELD.get(t);
            if (suppressedExceptions != null) {
                return suppressedExceptions.size();
            }
            return 0;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static int getNrRecursiveSuppressedExceptions(Throwable t) {
        try {
            List suppressedExceptions = (List)SUPPRESSED_FIELD.get(t);
            if (suppressedExceptions != null) {
                int count = 0;
                for (Throwable se : suppressedExceptions) {
                    count += 1 + Throwables.getNrRecursiveSuppressedExceptions(se);
                }
                return count;
            }
            return 0;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Throwable removeOldestSuppressedRecursive(Throwable t) {
        try {
            List suppressedExceptions = (List)SUPPRESSED_FIELD.get(t);
            if (suppressedExceptions != null && !suppressedExceptions.isEmpty()) {
                Throwable ex = (Throwable)suppressedExceptions.get(0);
                if (Throwables.getNrSuppressedExceptions(ex) > 0) {
                    return Throwables.removeOldestSuppressedRecursive(ex);
                }
                return (Throwable)suppressedExceptions.remove(0);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Throwable removeOldestSuppressed(Throwable t) {
        try {
            List suppressedExceptions = (List)SUPPRESSED_FIELD.get(t);
            if (suppressedExceptions != null && !suppressedExceptions.isEmpty()) {
                return (Throwable)suppressedExceptions.remove(0);
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void chain0(Throwable t, Throwable cause) {
        Throwable rc = com.google.common.base.Throwables.getRootCause((Throwable)t);
        Throwables.setCause(rc, cause);
    }

    private static void setCause(final Throwable rc, final @Nullable Throwable cause) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        CAUSE_FIELD.set(rc, cause);
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                    return null;
                }
            });
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T extends Throwable> T chain(T t, Throwable newRootCause) {
        return Throwables.chain(t, newRootCause, MAX_THROWABLE_CHAIN);
    }

    public static <T extends Throwable> T chain(T t, Throwable newRootCause, int maxChained) {
        T result;
        int chainedExNr = com.google.common.base.Throwables.getCausalChain(t).size();
        if (chainedExNr >= maxChained) {
            Lazy.LOG.warn("Trimming exception", newRootCause);
            return t;
        }
        List newRootCauseChain = com.google.common.base.Throwables.getCausalChain((Throwable)newRootCause);
        int newChainIdx = 0;
        int size = newRootCauseChain.size();
        if (chainedExNr + size > maxChained) {
            newChainIdx = size - (maxChained - chainedExNr);
            Lazy.LOG.warn("Trimming exception at {} ", (Object)newChainIdx, (Object)newRootCause);
        }
        try {
            result = Objects.clone(t);
        }
        catch (IOException ex) {
            result = t;
            Lazy.LOG.info("Unable to clone exception {}", t, (Object)ex);
        }
        Throwables.chain0(result, (Throwable)newRootCauseChain.get(newChainIdx));
        return result;
    }

    public static void trimCausalChain(Throwable t, int maxSize) {
        List causalChain = com.google.common.base.Throwables.getCausalChain((Throwable)t);
        if (causalChain.size() <= maxSize) {
            return;
        }
        Throwables.setCause((Throwable)causalChain.get(maxSize - 1), null);
    }

    @CheckReturnValue
    public static <T extends Throwable> T suppress(@Nonnull T t, @Nonnull Throwable suppressed) {
        return Throwables.suppress(t, suppressed, MAX_THROWABLE_CHAIN);
    }

    @CheckReturnValue
    public static <T extends Throwable> T suppress(@Nonnull T t, @Nonnull Throwable suppressed, int maxSuppressed) {
        T clone;
        try {
            clone = Objects.clone(t);
        }
        catch (IOException ex) {
            clone = t;
            Lazy.LOG.info("Unable to clone exception", t);
        }
        clone.addSuppressed(suppressed);
        while (Throwables.getNrRecursiveSuppressedExceptions(clone) > maxSuppressed) {
            if (Throwables.removeOldestSuppressedRecursive(clone) != null) continue;
            throw new IllegalArgumentException("Impossible state for " + clone);
        }
        return clone;
    }

    public static Throwable[] getSuppressed(Throwable t) {
        if (t instanceof Iterable) {
            ArrayList<Throwable> suppressed = new ArrayList<Throwable>(Arrays.asList(t.getSuppressed()));
            HashSet ignore = new HashSet();
            ignore.addAll(com.google.common.base.Throwables.getCausalChain((Throwable)t));
            for (Object next : (Iterable)((Object)t)) {
                if (!(next instanceof Throwable)) break;
                if (ignore.contains((Throwable)next)) continue;
                suppressed.add((Throwable)next);
                ignore.addAll(com.google.common.base.Throwables.getCausalChain((Throwable)((Throwable)next)));
            }
            return suppressed.toArray(new Throwable[suppressed.size()]);
        }
        return t.getSuppressed();
    }

    public static void writeTo(StackTraceElement element, Appendable to, Detail detail) throws IOException {
        to.append(element.getClassName());
        to.append('.');
        to.append(element.getMethodName());
        String fileName = element.getFileName();
        int lineNumber = element.getLineNumber();
        if (element.isNativeMethod()) {
            to.append("(Native Method)");
        } else if (fileName != null && lineNumber >= 0) {
            to.append('(').append(fileName).append(':').append(Integer.toString(lineNumber)).append(')');
        } else if (fileName != null) {
            to.append('(').append(fileName).append(')');
        } else {
            to.append("(Unknown Source)");
        }
        if (detail == Detail.NONE) {
            return;
        }
        Reflections.PackageInfo pInfo = Reflections.getPackageInfo(element.getClassName());
        if (pInfo.hasInfo()) {
            URL jarSourceUrl = pInfo.getUrl();
            String version = pInfo.getVersion();
            to.append('[');
            if (jarSourceUrl != null) {
                if (detail == Detail.SHORT_PACKAGE || detail == Detail.STANDARD) {
                    String url = jarSourceUrl.toString();
                    int lastIndexOf = url.lastIndexOf(47);
                    if (lastIndexOf >= 0) {
                        to.append(url, lastIndexOf + 1, url.length());
                    } else {
                        to.append(url);
                    }
                } else {
                    to.append(jarSourceUrl.toString());
                }
            } else {
                to.append("na");
            }
            if (version != null) {
                to.append(':');
                to.append(version);
            }
            to.append(']');
        }
    }

    public static String toString(Throwable t) {
        return Throwables.toString(t, DEFAULT_DETAIL);
    }

    public static String toString(Throwable t, Detail detail) {
        StringBuilder sb = Throwables.toStringBuilder(t, detail);
        return sb.toString();
    }

    public static StringBuilder toStringBuilder(Throwable t, Detail detail) {
        StringBuilder sb = new StringBuilder(1024);
        try {
            Throwables.writeTo(t, (Appendable)sb, detail);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OCP_OVERLY_CONCRETE_PARAMETER", "NOS_NON_OWNED_SYNCHRONIZATION"})
    public static void writeTo(@Nonnull Throwable t, @Nonnull PrintStream to, @Nonnull Detail detail) {
        try {
            PrintStream printStream = to;
            synchronized (printStream) {
                Throwables.writeTo(t, (Appendable)to, detail);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void writeTo(Throwable t, Appendable to, Detail detail) throws IOException {
        Set<Throwable> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        dejaVu.add(t);
        Throwables.toString(to, t);
        to.append('\n');
        StackTraceElement[] trace = t.getStackTrace();
        Throwables.writeTo(trace, to, detail);
        for (Throwable se : Throwables.getSuppressed(t)) {
            Throwables.printEnclosedStackTrace(se, to, trace, SUPPRESSED_CAPTION, "\t", dejaVu, detail);
        }
        Throwable ourCause = t.getCause();
        if (ourCause != null) {
            Throwables.printEnclosedStackTrace(ourCause, to, trace, CAUSE_CAPTION, "", dejaVu, detail);
        }
    }

    public static void toString(Appendable to, Throwable t) throws IOException {
        to.append(t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            to.append(':').append(message);
        }
    }

    public static void writeTo(StackTraceElement[] trace, Appendable to, Detail detail) throws IOException {
        for (StackTraceElement traceElement : trace) {
            to.append("\tat ");
            Throwables.writeTo(traceElement, to, detail);
            to.append('\n');
        }
    }

    public static int commonFrames(StackTraceElement[] trace, StackTraceElement[] enclosingTrace) {
        int m = trace.length - 1;
        for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
        }
        return trace.length - 1 - m;
    }

    private static void printEnclosedStackTrace(Throwable t, Appendable s, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu, Detail detail) throws IOException {
        if (dejaVu.contains(t)) {
            s.append("\t[CIRCULAR REFERENCE:");
            Throwables.toString(s, t);
            s.append(']');
        } else {
            dejaVu.add(t);
            StackTraceElement[] trace = t.getStackTrace();
            int framesInCommon = Throwables.commonFrames(trace, enclosingTrace);
            int m = trace.length - framesInCommon;
            s.append(prefix).append(caption);
            Throwables.toString(s, t);
            s.append('\n');
            for (int i = 0; i < m; ++i) {
                s.append(prefix).append("\tat ");
                Throwables.writeTo(trace[i], s, detail);
                s.append('\n');
            }
            if (framesInCommon != 0) {
                s.append(prefix).append("\t... ").append(Integer.toString(framesInCommon)).append(" more");
                s.append('\n');
            }
            for (Throwable se : Throwables.getSuppressed(t)) {
                Throwables.printEnclosedStackTrace(se, s, trace, SUPPRESSED_CAPTION, prefix + '\t', dejaVu, detail);
            }
            Throwable ourCause = t.getCause();
            if (ourCause != null) {
                Throwables.printEnclosedStackTrace(ourCause, s, trace, CAUSE_CAPTION, prefix, dejaVu, detail);
            }
        }
    }

    public static boolean isNonRecoverable(@Nonnull Throwable t) {
        return nrPredicate.test(t);
    }

    public static boolean containsNonRecoverable(@Nonnull Throwable t) {
        return Throwables.contains(t, nrPredicate);
    }

    public static boolean contains(@Nonnull Throwable t, Predicate<Throwable> predicate) {
        Throwable th;
        ArrayDeque<Throwable> toScan = new ArrayDeque<Throwable>();
        toScan.addFirst(t);
        IdentityHashSet seen = new IdentityHashSet();
        while ((th = (Throwable)toScan.pollFirst()) != null) {
            if (seen.contains(th)) continue;
            if (predicate.test(th)) {
                return true;
            }
            Throwable cause = th.getCause();
            if (cause != null) {
                toScan.addFirst(cause);
            }
            for (Throwable supp : th.getSuppressed()) {
                toScan.addLast(supp);
            }
            seen.add(th);
        }
        return false;
    }

    public static Predicate<Throwable> getNonRecoverablePredicate() {
        return nrPredicate;
    }

    public static void setNonRecoverablePredicate(Predicate<Throwable> predicate) {
        nrPredicate = predicate;
    }

    public static enum Detail {
        NONE,
        STANDARD,
        SHORT_PACKAGE,
        LONG_PACKAGE;

    }

    static final class Lazy {
        private static final Logger LOG = LoggerFactory.getLogger(Lazy.class);

        Lazy() {
        }
    }
}

