/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AggregateTranslator;
import org.spf4j.base.Arrays;
import org.spf4j.base.CharSequenceTranslator;
import org.spf4j.base.CharSequences;
import org.spf4j.base.LookupTranslator;
import org.spf4j.base.OctalUnescaper;
import org.spf4j.base.UnicodeUnescaper;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;

@SuppressFBWarnings(value={"IICU_INCORRECT_INTERNAL_CLASS_USE"})
public final class Strings {
    public static final String EOL = System.getProperty("line.separator", "\n");
    private static final String[][] JAVA_CTRL_CHARS_UNESCAPE = new String[][]{{"\\b", "\b"}, {"\\n", "\n"}, {"\\t", "\t"}, {"\\f", "\f"}, {"\\r", "\r"}};
    private static final CharSequenceTranslator UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(JAVA_CTRL_CHARS_UNESCAPE), new LookupTranslator({"\\\\", "\\"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\", ""}));
    private static final Logger LOG = LoggerFactory.getLogger(Strings.class);
    private static final MethodHandle CHARS_FIELD_GET;
    private static final MethodHandle PROTECTED_STR_CONSTR_HANDLE;
    private static final Class<?>[] PROTECTED_STR_CONSTR_PARAM_TYPES;
    private static final boolean LENIENT_CODING;
    private static final ThreadLocal<CharsetEncoder> UTF8_ENCODER;
    private static final ThreadLocal<CharsetDecoder> UTF8_DECODER;
    private static final char[] DIGITS;
    private static final ThreadLocal<char[]> BUFF;

    private Strings() {
    }

    public static int distance(@Nonnull String s1, @Nonnull String s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        int[] prev = new int[l2];
        char c1 = s1.charAt(0);
        prev[0] = Strings.distance(c1, s2.charAt(0));
        for (int j = 1; j < l2; ++j) {
            prev[j] = prev[j - 1] + Strings.distance(c1, s2.charAt(j));
        }
        for (int i = 1; i < l1; ++i) {
            int[] dist = new int[l2];
            c1 = s1.charAt(i);
            dist[0] = prev[i - 1] + Strings.distance(c1, s2.charAt(0));
            for (int j = 1; j < l2; ++j) {
                dist[j] = Math.min(prev[j - 1] + Strings.distance(c1, s2.charAt(j)), Math.min(prev[j] + 1, dist[j - 1] + 1));
            }
            prev = dist;
        }
        return prev[l2 - 1];
    }

    public static int distance(char c1, char c2) {
        if (c1 == c2) {
            return 0;
        }
        return 1;
    }

    public static String unescape(String what) {
        return UNESCAPE_JAVA.translate(what);
    }

    public static boolean contains(String string, char ... chars) {
        for (char c : chars) {
            if (string.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence string, char ... chars) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Arrays.search(chars, c) < 0) continue;
            return true;
        }
        return false;
    }

    public static String withFirstCharLower(String str) {
        if (str.isEmpty()) {
            return str;
        }
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        int l = str.length();
        StringBuilder result = new StringBuilder(l);
        result.append(Character.toLowerCase(str.charAt(0)));
        for (int i = 1; i < l; ++i) {
            result.append(str.charAt(i));
        }
        return result.toString();
    }

    public static void writeReplaceWhitespaces(String str, char replacement, Appendable writer) throws IOException {
        for (char c : Strings.steal(str)) {
            if (Character.isWhitespace(c)) {
                writer.append(replacement);
                continue;
            }
            writer.append(c);
        }
    }

    public static char[] steal(String str) {
        if (CHARS_FIELD_GET == null) {
            return str.toCharArray();
        }
        try {
            return CHARS_FIELD_GET.invokeExact(str);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String wrap(char[] chars) {
        if (PROTECTED_STR_CONSTR_PARAM_TYPES != null) {
            try {
                if (PROTECTED_STR_CONSTR_PARAM_TYPES.length == 3) {
                    return PROTECTED_STR_CONSTR_HANDLE.invokeExact(0, chars.length, chars);
                }
                return PROTECTED_STR_CONSTR_HANDLE.invokeExact(chars, true);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        return new String(chars);
    }

    public static CharsetEncoder createUtf8Encoder() {
        if (LENIENT_CODING) {
            return Charsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return Charsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public static CharsetDecoder createUtf8Decoder() {
        if (LENIENT_CODING) {
            return Charsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return Charsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    public static CharsetEncoder getUTF8CharsetEncoder() {
        return UTF8_ENCODER.get();
    }

    public static CharsetDecoder getUTF8CharsetDecoder() {
        return UTF8_DECODER.get();
    }

    @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
    public static byte[] encode(CharsetEncoder ce, char[] ca, int off, int len) {
        if (len == 0) {
            return Arrays.EMPTY_BYTE_ARRAY;
        }
        byte[] ba = Arrays.getBytesTmp(Strings.getmaxNrBytes(ce, len));
        int nrBytes = Strings.encode(ce, ca, off, len, ba);
        return java.util.Arrays.copyOf(ba, nrBytes);
    }

    public static int getmaxNrBytes(CharsetEncoder ce, int nrChars) {
        return (int)((double)nrChars * (double)ce.maxBytesPerChar());
    }

    public static int encode(CharsetEncoder ce, char[] ca, int off, int len, byte[] targetArray) {
        if (len == 0) {
            return 0;
        }
        if (ce instanceof ArrayEncoder) {
            return ((ArrayEncoder)((Object)ce)).encode(ca, off, len, targetArray);
        }
        ce.reset();
        ByteBuffer bb = ByteBuffer.wrap(targetArray);
        CharBuffer cb = CharBuffer.wrap(ca, off, len);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return bb.position();
    }

    @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
    public static String decode(CharsetDecoder cd, byte[] ba, int off, int len) {
        if (len == 0) {
            return "";
        }
        int en = (int)((double)len * (double)cd.maxCharsPerByte());
        char[] ca = Arrays.getCharsTmp(en);
        if (cd instanceof ArrayDecoder) {
            int clen = ((ArrayDecoder)((Object)cd)).decode(ba, off, len, ca);
            return new String(ca, 0, clen);
        }
        cd.reset();
        ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
        CharBuffer cb = CharBuffer.wrap(ca);
        try {
            CoderResult cr = cd.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = cd.flush(cb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return new String(ca, 0, cb.position());
    }

    public static String fromUtf8(byte[] bytes) {
        return Strings.decode(UTF8_DECODER.get(), bytes, 0, bytes.length);
    }

    public static String fromUtf8(byte[] bytes, int startIdx, int length) {
        return Strings.decode(UTF8_DECODER.get(), bytes, startIdx, length);
    }

    public static byte[] toUtf8(String str) {
        char[] chars = Strings.steal(str);
        return Strings.encode(UTF8_ENCODER.get(), chars, 0, chars.length);
    }

    @Deprecated
    public static int compareTo(@Nonnull CharSequence s, @Nonnull CharSequence t) {
        return CharSequences.compareTo(s, t);
    }

    @Deprecated
    public static boolean equals(@Nonnull CharSequence s, @Nonnull CharSequence t) {
        return CharSequences.equals(s, t);
    }

    @Deprecated
    public static int hashcode(CharSequence cs) {
        return CharSequences.hashcode(cs);
    }

    @Deprecated
    public static CharSequence subSequence(CharSequence seq, int startIdx, int endIdx) {
        return CharSequences.subSequence(seq, startIdx, endIdx);
    }

    @Deprecated
    public static boolean endsWith(CharSequence qc, CharSequence with) {
        return CharSequences.endsWith(qc, with);
    }

    public static void escapeJsonString(@Nonnull String toEscape, StringBuilder jsonString) {
        int len = toEscape.length();
        for (int i = 0; i < len; ++i) {
            char c = toEscape.charAt(i);
            Strings.appendJsonStringEscapedChar(c, jsonString);
        }
    }

    public static void escapeJsonString(@Nonnull String toEscape, Appendable jsonString) throws IOException {
        int len = toEscape.length();
        for (int i = 0; i < len; ++i) {
            char c = toEscape.charAt(i);
            Strings.appendJsonStringEscapedChar(c, jsonString);
        }
    }

    public static void appendJsonStringEscapedChar(char c, StringBuilder jsonString) {
        switch (c) {
            case '\"': 
            case '\\': {
                jsonString.append('\\');
                jsonString.append(c);
                break;
            }
            case '\b': {
                jsonString.append("\\b");
                break;
            }
            case '\t': {
                jsonString.append("\\t");
                break;
            }
            case '\n': {
                jsonString.append("\\n");
                break;
            }
            case '\f': {
                jsonString.append("\\f");
                break;
            }
            case '\r': {
                jsonString.append("\\r");
                break;
            }
            default: {
                if (c < ' ') {
                    jsonString.append("\\u");
                    Strings.appendUnsignedStringPadded(jsonString, (int)c, 4, 4);
                    break;
                }
                jsonString.append(c);
            }
        }
    }

    public static void appendJsonStringEscapedChar(char c, Appendable jsonString) throws IOException {
        switch (c) {
            case '\"': 
            case '\\': {
                jsonString.append('\\');
                jsonString.append(c);
                break;
            }
            case '\b': {
                jsonString.append("\\b");
                break;
            }
            case '\t': {
                jsonString.append("\\t");
                break;
            }
            case '\n': {
                jsonString.append("\\n");
                break;
            }
            case '\f': {
                jsonString.append("\\f");
                break;
            }
            case '\r': {
                jsonString.append("\\r");
                break;
            }
            default: {
                if (c < ' ') {
                    jsonString.append("\\u");
                    Strings.appendUnsignedStringPadded(jsonString, (int)c, 4, 4);
                    break;
                }
                jsonString.append(c);
            }
        }
    }

    public static void appendUnsignedString(StringBuilder sb, long nr, int shift) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        sb.append(buf, charPos, 64 - charPos);
    }

    public static void appendUnsignedString(StringBuilder sb, int nr, int shift) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        sb.append(buf, charPos, 32 - charPos);
    }

    public static void appendUnsignedStringPadded(StringBuilder sb, int nr, int shift, int padTo) {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        int nrChars = 32 - charPos;
        if (nrChars > padTo) {
            throw new IllegalArgumentException("Your pad to value " + padTo + " is to small, must be at least " + nrChars);
        }
        int n = padTo - nrChars;
        for (int j = 0; j < n; ++j) {
            sb.append('0');
        }
        sb.append(buf, charPos, nrChars);
    }

    public static void appendUnsignedStringPadded(Appendable sb, int nr, int shift, int padTo) throws IOException {
        long i = nr;
        char[] buf = BUFF.get();
        int charPos = 32;
        int radix = 1 << shift;
        long mask = radix - 1;
        do {
            buf[--charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        int nrChars = 32 - charPos;
        if (nrChars > padTo) {
            throw new IllegalArgumentException("Your pad to value " + padTo + " is to small, must be at least " + nrChars);
        }
        int n = padTo - nrChars;
        for (int j = 0; j < n; ++j) {
            sb.append('0');
        }
        sb.append(CharBuffer.wrap(buf), charPos, charPos + nrChars);
    }

    public static void appendSpaces(Appendable to, int nrSpaces) throws IOException {
        for (int i = 0; i < nrSpaces; ++i) {
            to.append(' ');
        }
    }

    public static void appendSpaces(StringBuilder to, int nrSpaces) {
        for (int i = 0; i < nrSpaces; ++i) {
            to.append(' ');
        }
    }

    public static boolean regionMatches(CharSequence t, int toffset, CharSequence other, int ooffset, int plen) {
        int to = toffset;
        int po = ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)t.length() - (long)plen || (long)ooffset > (long)other.length() - (long)plen) {
            return false;
        }
        int len = plen;
        while (len-- > 0) {
            if (t.charAt(to++) == other.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public static String truncate(@Nonnull String value, int length) {
        if (value.length() > length) {
            return value.substring(0, length);
        }
        return value;
    }

    @Nonnull
    public static String commonPrefix(String ... strs) {
        Preconditions.checkArgument((strs.length > 0 ? 1 : 0) != 0, (String)"Must have at least 1 string %s", (Object[])strs);
        String common = strs[0];
        for (int i = 1; i < strs.length; ++i) {
            common = com.google.common.base.Strings.commonPrefix((CharSequence)common, (CharSequence)strs[i]);
        }
        return common;
    }

    static {
        Field charsField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Field charsField;
                try {
                    charsField = String.class.getDeclaredField("value");
                    charsField.setAccessible(true);
                }
                catch (NoSuchFieldException ex) {
                    LOG.info("char array stealing from String not supported", (Throwable)ex);
                    charsField = null;
                }
                catch (SecurityException ex) {
                    throw new RuntimeException(ex);
                }
                return charsField;
            }
        });
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (charsField != null) {
            try {
                CHARS_FIELD_GET = lookup.unreflectGetter(charsField);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        } else {
            CHARS_FIELD_GET = null;
        }
        Constructor<String> prConstr = AccessController.doPrivileged(new PrivilegedAction<Constructor<String>>(){

            @Override
            public Constructor<String> run() {
                Constructor<String> constr;
                try {
                    constr = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                    constr.setAccessible(true);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        constr = String.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, char[].class);
                        constr.setAccessible(true);
                    }
                    catch (NoSuchMethodException ex2) {
                        ex2.addSuppressed(ex);
                        LOG.info("building String from char[] fast not supported", (Throwable)ex2);
                        constr = null;
                    }
                    catch (SecurityException ex2) {
                        ex2.addSuppressed(ex);
                        throw new RuntimeException(ex2);
                    }
                }
                catch (SecurityException ex) {
                    throw new RuntimeException(ex);
                }
                return constr;
            }
        });
        if (prConstr == null) {
            PROTECTED_STR_CONSTR_PARAM_TYPES = null;
            PROTECTED_STR_CONSTR_HANDLE = null;
        } else {
            PROTECTED_STR_CONSTR_PARAM_TYPES = prConstr.getParameterTypes();
            try {
                PROTECTED_STR_CONSTR_HANDLE = lookup.unreflectConstructor(prConstr);
            }
            catch (IllegalAccessException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        LENIENT_CODING = Boolean.getBoolean("spf4j.encoding.lenient");
        UTF8_ENCODER = new ThreadLocal<CharsetEncoder>(){

            @Override
            protected CharsetEncoder initialValue() {
                return Strings.createUtf8Encoder();
            }
        };
        UTF8_DECODER = new ThreadLocal<CharsetDecoder>(){

            @Override
            protected CharsetDecoder initialValue() {
                return Strings.createUtf8Decoder();
            }
        };
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        BUFF = new ThreadLocal<char[]>(){

            @Override
            @SuppressFBWarnings(value={"SUA_SUSPICIOUS_UNINITIALIZED_ARRAY"})
            protected char[] initialValue() {
                return new char[64];
            }
        };
    }
}

