/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.spf4j.base.Holder;
import org.spf4j.concurrent.UnboundedLoadingCache;

@ParametersAreNonnullByDefault
public final class Reflections {
    private static final BiMap<Class<?>, Class<?>> PRIMITIVE_MAP = HashBiMap.create((int)8);
    private static final LoadingCache<MethodDesc, Holder<Method>> CACHE_FAST;
    private static final LoadingCache<MethodDesc, MethodHandle> CACHE_FAST_MH;
    private static final PackageInfo NONE;
    private static final LoadingCache<String, PackageInfo> CACHE;

    private Reflections() {
    }

    public static Class<?> primitiveToWrapper(Class<?> clasz) {
        if (clasz.isPrimitive()) {
            return (Class)PRIMITIVE_MAP.get(clasz);
        }
        return clasz;
    }

    public static Class<?> wrapperToPrimitive(Class<?> clasz) {
        if (clasz.isPrimitive()) {
            return clasz;
        }
        return (Class)PRIMITIVE_MAP.inverse().get(clasz);
    }

    public static boolean isWrappableOrWrapper(Class clasz) {
        return PRIMITIVE_MAP.containsKey((Object)clasz) || PRIMITIVE_MAP.containsValue((Object)clasz);
    }

    public static Object getAnnotationAttribute(@Nonnull Annotation annot, @Nonnull String attributeName) {
        for (Method method : annot.annotationType().getDeclaredMethods()) {
            if (!method.getName().equals(attributeName)) continue;
            try {
                return method.invoke((Object)annot, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new IllegalArgumentException(attributeName + " attribute is not present on annotation " + annot);
    }

    @Nullable
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="comparing interned strings")
    public static Method getMethod(Class<?> c, String methodName, Class<?> ... paramTypes) {
        String internedName = methodName.intern();
        for (Method m : c.getDeclaredMethods()) {
            if (m.getName() != internedName || !Arrays.equals(paramTypes, m.getParameterTypes())) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public static Constructor<?> getConstructor(Class<?> c, Class<?> ... paramTypes) {
        for (Constructor<?> cons : c.getDeclaredConstructors()) {
            if (!Arrays.equals(cons.getParameterTypes(), paramTypes)) continue;
            return cons;
        }
        return null;
    }

    @Nullable
    public static Method getCompatibleMethod(Class<?> c, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        for (Method m : methods = c.getMethods()) {
            Class<?>[] actualTypes;
            if (!methodName.equals(m.getName()) || (actualTypes = m.getParameterTypes()).length > paramTypes.length) continue;
            boolean found = true;
            int last = actualTypes.length - 1;
            for (int j = 0; j < actualTypes.length; ++j) {
                Class<?> actType = actualTypes[j];
                Class<?> paramType = paramTypes[j];
                found = Reflections.canAssign(actType, paramType);
                if (!found && j == last) {
                    if (actType.isArray()) {
                        boolean matchvararg = true;
                        Class<?> varargType = actType.getComponentType();
                        for (int k = j; k < paramTypes.length; ++k) {
                            if (Reflections.canAssign(varargType, paramTypes[k])) continue;
                            matchvararg = false;
                            break;
                        }
                        found = matchvararg;
                    }
                } else if (j == last && actualTypes.length < paramTypes.length) {
                    found = false;
                }
                if (!found) break;
            }
            if (!found) continue;
            return m;
        }
        return null;
    }

    @Nullable
    public static MethodHandle getCompatibleMethodHandle(Class<?> c, String methodName, Class<?> ... paramTypes) {
        Method compatibleMethod = Reflections.getCompatibleMethod(c, methodName, paramTypes);
        if (compatibleMethod == null) {
            return null;
        }
        try {
            return MethodHandles.lookup().unreflect(compatibleMethod);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object invoke(Method m, Object object, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        int np = parameters.length;
        if (np > 0) {
            Class<?>[] actTypes = m.getParameterTypes();
            Class<?> lastParamClass = actTypes[actTypes.length - 1];
            if (Reflections.canAssign(lastParamClass, parameters[np - 1].getClass())) {
                return m.invoke(object, parameters);
            }
            if (lastParamClass.isArray()) {
                int lidx = actTypes.length - 1;
                int l = np - lidx;
                Object array = Array.newInstance(lastParamClass.getComponentType(), l);
                for (int k = 0; k < l; ++k) {
                    Array.set(array, k, parameters[lidx + k]);
                }
                Object[] newParams = new Object[actTypes.length];
                System.arraycopy(parameters, 0, newParams, 0, lidx);
                newParams[lidx] = array;
                return m.invoke(object, newParams);
            }
            throw new IllegalStateException();
        }
        return m.invoke(object, new Object[0]);
    }

    public static boolean canAssign(Class<?> to, Class<?> from) {
        boolean found = true;
        if (!to.isAssignableFrom(from)) {
            if (to.isPrimitive()) {
                Class boxed = (Class)PRIMITIVE_MAP.get(to);
                found = boxed.equals(from);
            } else {
                found = from.isPrimitive() ? ((Class)PRIMITIVE_MAP.get(from)).equals(to) : false;
            }
        }
        return found;
    }

    @Nullable
    public static Method getCompatibleMethodCached(Class<?> c, String methodName, Class<?> ... paramTypes) {
        return (Method)((Holder)CACHE_FAST.getUnchecked((Object)new MethodDesc(c, methodName, paramTypes))).getValue();
    }

    public static MethodHandle getCompatibleMethodHandleCached(Class<?> c, String methodName, Class<?> ... paramTypes) {
        return (MethodHandle)CACHE_FAST_MH.getUnchecked((Object)new MethodDesc(c, methodName, paramTypes));
    }

    @Nullable
    public static URL getJarSourceUrl(Class<?> clasz) {
        CodeSource codeSource = clasz.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        return codeSource.getLocation();
    }

    @Nullable
    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public static Manifest getManifest(@Nonnull URL jarUrl) throws IOException {
        try (JarInputStream jis = new JarInputStream(jarUrl.openStream());){
            Manifest manifest = jis.getManifest();
            return manifest;
        }
    }

    @Nonnull
    public static PackageInfo getPackageInfoDirect(@Nonnull String className) {
        Class<?> aClass;
        try {
            aClass = Class.forName(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            return NONE;
        }
        return Reflections.getPackageInfoDirect(aClass);
    }

    @Nonnull
    public static PackageInfo getPackageInfoDirect(@Nonnull Class<?> aClass) {
        URL jarSourceUrl = Reflections.getJarSourceUrl(aClass);
        Package aPackage = aClass.getPackage();
        if (aPackage == null) {
            return NONE;
        }
        String version = aPackage.getImplementationVersion();
        return new PackageInfo(jarSourceUrl, version);
    }

    @Nonnull
    public static PackageInfo getPackageInfo(@Nonnull String className) {
        return (PackageInfo)CACHE.getUnchecked((Object)className);
    }

    public static <T> T implementStatic(Class<T> clasz, Class<?> target) {
        Method[] methods = clasz.getMethods();
        HashMap<Method, Method> map = new HashMap<Method, Method>(methods.length);
        for (Method from : methods) {
            Method to = Reflections.getCompatibleMethodCached(target, from.getName(), from.getParameterTypes());
            if (to == null || !Modifier.isStatic(to.getModifiers())) {
                throw new IllegalArgumentException("Cannot map from " + clasz + " to " + target);
            }
            map.put(from, to);
        }
        return (T)Proxy.newProxyInstance(clasz.getClassLoader(), new Class[]{clasz}, (proxy, method, args) -> ((Method)map.get(method)).invoke(null, args));
    }

    public static <T> T implement(Class<T> clasz, Object target) {
        Method[] methods = clasz.getMethods();
        HashMap<Method, Method> map = new HashMap<Method, Method>(methods.length);
        Class<?> aClass = target.getClass();
        for (Method from : methods) {
            Method to = Reflections.getCompatibleMethodCached(aClass, from.getName(), from.getParameterTypes());
            if (to == null) {
                throw new IllegalArgumentException("Cannot map from " + clasz + " to " + target);
            }
            map.put(from, to);
        }
        return (T)Proxy.newProxyInstance(clasz.getClassLoader(), new Class[]{clasz}, (proxy, method, args) -> ((Method)map.get(method)).invoke(target, args));
    }

    static {
        PRIMITIVE_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_MAP.put(Double.TYPE, Double.class);
        CACHE_FAST = new UnboundedLoadingCache<MethodDesc, Holder<Method>>(64, new CacheLoader<MethodDesc, Holder<Method>>(){

            public Holder<Method> load(MethodDesc k) {
                final Method m = Reflections.getCompatibleMethod(k.getClasz(), k.getName(), k.getParamTypes());
                if (m == null) {
                    return Holder.OF_NULL;
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        m.setAccessible(true);
                        return null;
                    }
                });
                return Holder.of(m);
            }
        });
        CACHE_FAST_MH = new UnboundedLoadingCache<MethodDesc, MethodHandle>(64, new CacheLoader<MethodDesc, MethodHandle>(){

            public MethodHandle load(MethodDesc k) {
                return Reflections.getCompatibleMethodHandle(k.getClasz(), k.getName(), k.getParamTypes());
            }
        });
        NONE = new PackageInfo(null, null);
        CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<String, PackageInfo>(){

            public PackageInfo load(String key) {
                return Reflections.getPackageInfoDirect(key);
            }
        });
    }

    public static final class PackageInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URL url;
        private final String version;

        @ConstructorProperties(value={"url", "version"})
        public PackageInfo(@Nullable URL url, @Nullable String version) {
            this.url = url;
            this.version = version;
        }

        @Nullable
        public URL getUrl() {
            return this.url;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"})
        public int hashCode() {
            if (this.url != null) {
                return this.url.hashCode();
            }
            return 0;
        }

        public boolean hasInfo() {
            return this.url != null || this.version != null;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageInfo other = (PackageInfo)obj;
            if (!Objects.equals(this.url, other.url)) {
                return false;
            }
            return Objects.equals(this.version, other.version);
        }

        public String toString() {
            return "PackageInfo{url=" + this.url + ", version=" + this.version + '}';
        }
    }

    static final class MethodDesc {
        @Nonnull
        private final Class<?> clasz;
        @Nonnull
        private final String name;
        @Nonnull
        private final Class<?>[] paramTypes;

        MethodDesc(Class<?> clasz, String name, Class<?>[] paramTypes) {
            this.clasz = clasz;
            this.name = name;
            this.paramTypes = paramTypes;
        }

        public Class<?> getClasz() {
            return this.clasz;
        }

        public String getName() {
            return this.name;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public int hashCode() {
            return 47 * this.clasz.hashCode() + this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof MethodDesc) {
                MethodDesc other = (MethodDesc)obj;
                if (!this.clasz.equals(other.clasz)) {
                    return false;
                }
                if (!this.name.equals(other.name)) {
                    return false;
                }
                return Arrays.equals(this.paramTypes, other.paramTypes);
            }
            return false;
        }

        public String toString() {
            return "MethodDesc{clasz=" + this.clasz + ',' + " name=" + this.name + ", paramTypes=" + Arrays.toString(this.paramTypes) + '}';
        }
    }
}

