/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

public abstract class Either<A, B> {
    protected final Object value;

    private Either(Object value) {
        this.value = value;
    }

    public abstract boolean isLeft();

    public boolean isRight() {
        return !this.isLeft();
    }

    public abstract A getLeft();

    public abstract B getRight();

    public int hashCode() {
        return 73 + (this.value != null ? this.value.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Either other = (Either)obj;
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    public String toString() {
        return "Either{value=" + this.value + '}';
    }

    public static <A, B> Either<A, B> left(A a) {
        return new Left(a);
    }

    public static <A, B> Either<A, B> right(B b) {
        return new Right(b);
    }

    public static final class Right<A, B>
    extends Either<A, B> {
        public Right(B b) {
            super(b);
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public A getLeft() {
            throw new UnsupportedOperationException("This union doe not have a left val, instead a " + this.value);
        }

        @Override
        public B getRight() {
            return (B)this.value;
        }
    }

    public static final class Left<A, B>
    extends Either<A, B> {
        public Left(A a) {
            super(a);
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public A getLeft() {
            return (A)this.value;
        }

        @Override
        public B getRight() {
            throw new UnsupportedOperationException("This union doe not have a right val, instead a " + this.value);
        }
    }
}

