/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;

public class MatchingStandardLicenses {
    static int MIN_ARGS = 1;
    static int MAX_ARGS = 1;
    static final int ERROR_STATUS = 1;

    private MatchingStandardLicenses() {
    }

    public static void main(String[] args) {
        File textFile;
        if (args == null || args.length < MIN_ARGS || args.length > MAX_ARGS) {
            System.out.println("Invalid arguments");
            MatchingStandardLicenses.usage();
            System.exit(1);
        }
        if (!(textFile = new File(args[0])).exists()) {
            System.out.println("Text file " + textFile.getName() + " does not exist");
            MatchingStandardLicenses.usage();
            System.exit(1);
        }
        String licenseText = null;
        try {
            licenseText = MatchingStandardLicenses.readAll(textFile);
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + e.getMessage());
            System.exit(1);
        }
        String[] matchingLicenseIds = null;
        try {
            matchingLicenseIds = LicenseCompareHelper.matchingStandardLicenseIds(licenseText);
        }
        catch (InvalidSPDXAnalysisException e) {
            System.out.println("Error reading standard licenses: " + e.getMessage());
            System.exit(1);
        }
        catch (SpdxCompareException e) {
            System.out.println("Error comparing licenses: " + e.getMessage());
            System.exit(1);
        }
        if (matchingLicenseIds == null || matchingLicenseIds.length == 0) {
            System.out.println("No standard licenses matched.");
        } else {
            StringBuilder sb = new StringBuilder("The following license id(s) match: ");
            sb.append(matchingLicenseIds[0]);
            for (int i = 1; i < matchingLicenseIds.length; ++i) {
                sb.append(", ");
                sb.append(matchingLicenseIds[i]);
            }
            System.out.println(sb.toString());
        }
        System.exit(0);
    }

    private static String readAll(File textFile) throws IOException {
        return Files.toString((File)textFile, (Charset)Charset.defaultCharset());
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("MatchingStandardLicenses textfile.txt");
        System.out.println("   textfile.txt is a text file containing the license text to compare.");
    }
}

