/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseSet;
import org.spdx.rdfparser.model.IRdfModel;

public class ConjunctiveLicenseSet
extends LicenseSet {
    public ConjunctiveLicenseSet(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
    }

    public ConjunctiveLicenseSet(AnyLicenseInfo[] conjunctiveLicenses) {
        super(conjunctiveLicenses);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        boolean moreThanOne = false;
        Iterator iter = this.licenseInfos.iterator();
        while (iter.hasNext()) {
            if (moreThanOne) {
                sb.append(" AND ");
            }
            moreThanOne = true;
            sb.append(((AnyLicenseInfo)iter.next()).toString());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int retval = 41;
        AnyLicenseInfo[] allMembers = this.getFlattenedMembers();
        for (int i = 0; i < allMembers.length; ++i) {
            retval ^= allMembers[i].hashCode();
        }
        return retval;
    }

    @Override
    public boolean equals(Object o) {
        AnyLicenseInfo[] myInfos;
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConjunctiveLicenseSet)) {
            return false;
        }
        ConjunctiveLicenseSet comp = (ConjunctiveLicenseSet)o;
        AnyLicenseInfo[] compInfos = comp.getFlattenedMembers();
        if (compInfos.length != (myInfos = this.getFlattenedMembers()).length) {
            return false;
        }
        for (int j = 0; j < myInfos.length; ++j) {
            AnyLicenseInfo li = myInfos[j];
            boolean found = false;
            for (int i = 0; i < compInfos.length; ++i) {
                if (!li.equals(compInfos[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public AnyLicenseInfo[] getFlattenedMembers() {
        if (this.resource != null && this.refreshOnGet) {
            try {
                this.getPropertiesFromModel();
            }
            catch (InvalidSPDXAnalysisException e) {
                logger.warn("Error getting properites from model, using stored values.", (Throwable)e);
            }
        }
        HashSet<AnyLicenseInfo> retval = new HashSet<AnyLicenseInfo>();
        for (AnyLicenseInfo li : this.licenseInfos) {
            if (li instanceof ConjunctiveLicenseSet) {
                AnyLicenseInfo[] members = ((ConjunctiveLicenseSet)li).getFlattenedMembers();
                for (int i = 0; i < members.length; ++i) {
                    retval.add(members[i]);
                }
                continue;
            }
            retval.add(li);
        }
        return retval.toArray(new AnyLicenseInfo[retval.size()]);
    }

    @Override
    public AnyLicenseInfo clone() {
        AnyLicenseInfo[] clonedSet = new AnyLicenseInfo[this.licenseInfos.size()];
        Iterator iter = this.licenseInfos.iterator();
        int i = 0;
        while (iter.hasNext()) {
            clonedSet[i++] = ((AnyLicenseInfo)iter.next()).clone();
        }
        return new ConjunctiveLicenseSet(clonedSet);
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        AnyLicenseInfo[] myInfos;
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof ConjunctiveLicenseSet)) {
            return false;
        }
        ConjunctiveLicenseSet comp = (ConjunctiveLicenseSet)compare;
        AnyLicenseInfo[] compInfos = comp.getFlattenedMembers();
        if (compInfos.length != (myInfos = this.getFlattenedMembers()).length) {
            return false;
        }
        for (int j = 0; j < myInfos.length; ++j) {
            AnyLicenseInfo li = myInfos[j];
            boolean found = false;
            for (int i = 0; i < compInfos.length; ++i) {
                if (!li.equivalent(compInfos[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#ConjunctiveLicenseSet");
    }
}

