/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import java.util.Map;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;

public class RelationshipContext {
    private String relatedElementId;
    private String comment;
    private String type;
    private String elementLink;

    public RelationshipContext() {
    }

    public RelationshipContext(Relationship relationship, Map<String, String> idToUrlMap) {
        if (relationship == null) {
            return;
        }
        SpdxElement relatedElement = relationship.getRelatedSpdxElement();
        if (relatedElement != null) {
            this.relatedElementId = relatedElement.getId();
        }
        this.type = relationship.getRelationshipType().toTag();
        this.comment = relationship.getComment();
        this.elementLink = idToUrlMap.get(this.relatedElementId);
    }

    public String getRelatedElementId() {
        return this.relatedElementId;
    }

    public void setRelatedElementId(String relatedElementId) {
        this.relatedElementId = relatedElementId;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getElementLink() {
        return this.elementLink;
    }

    public void setElementLink(String elementLink) {
        this.elementLink = elementLink;
    }
}

