/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxSnippetComparer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxItem;

public class SpdxItemComparer {
    private boolean inProgress = false;
    private boolean differenceFound = false;
    private boolean concludedLicenseEquals = true;
    private boolean seenLicenseEquals = true;
    protected String name = null;
    private Map<SpdxDocument, Map<SpdxDocument, AnyLicenseInfo[]>> uniqueLicenseInfosInFiles = Maps.newHashMap();
    private boolean commentsEquals = true;
    private boolean copyrightsEquals = true;
    private boolean licenseCommmentsEquals = true;
    private boolean relationshipsEquals = true;
    Map<SpdxDocument, Map<SpdxDocument, Relationship[]>> uniqueRelationships = Maps.newHashMap();
    private boolean annotationsEquals = true;
    private Map<SpdxDocument, Map<SpdxDocument, Annotation[]>> uniqueAnnotations = Maps.newHashMap();
    protected Map<SpdxDocument, SpdxItem> documentItem = Maps.newHashMap();
    protected Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap;

    public SpdxItemComparer(Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) {
        this.extractedLicenseIdMap = extractedLicenseIdMap;
    }

    public void addDocumentItem(SpdxDocument spdxDocument, SpdxItem spdxItem) throws SpdxCompareException {
        if (this.inProgress) {
            throw new SpdxCompareException("Trying to add a document item while another document item is being added.");
        }
        if (this.name == null) {
            this.name = spdxItem.getName();
        } else if (!this.name.equals(spdxItem.getName()) && !(this instanceof SpdxSnippetComparer)) {
            throw new SpdxCompareException("Names do not match for item being added to comparer: " + spdxItem.getName() + ", expecting " + this.name);
        }
        this.inProgress = true;
        this.differenceFound = false;
        Iterator<Map.Entry<SpdxDocument, SpdxItem>> iter = this.documentItem.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<SpdxDocument, SpdxItem> entry = iter.next();
            SpdxItem itemB = entry.getValue();
            Map<String, String> licenseXlationMap = this.extractedLicenseIdMap.get(spdxDocument).get(entry.getKey());
            if (!SpdxComparer.stringsEqual(spdxItem.getComment(), itemB.getComment())) {
                this.commentsEquals = false;
                this.differenceFound = true;
            }
            if (!LicenseCompareHelper.isLicenseEqual(spdxItem.getLicenseConcluded(), itemB.getLicenseConcluded(), licenseXlationMap)) {
                this.concludedLicenseEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxItem.getCopyrightText(), itemB.getCopyrightText())) {
                this.copyrightsEquals = false;
                this.differenceFound = true;
            }
            if (!SpdxComparer.stringsEqual(spdxItem.getLicenseComments(), itemB.getLicenseComments())) {
                this.licenseCommmentsEquals = false;
                this.differenceFound = true;
            }
            this.compareLicenseInfosInFiles(spdxDocument, spdxItem.getLicenseInfoFromFiles());
            this.compareRelationships(spdxDocument, spdxItem.getRelationships());
            this.compareAnnotation(spdxDocument, spdxItem.getAnnotations());
        }
        this.documentItem.put(spdxDocument, spdxItem);
        this.inProgress = false;
    }

    private void compareAnnotation(SpdxDocument spdxDocument, Annotation[] annotations) {
        HashMap uniqueDocAnnotations = this.uniqueAnnotations.get(spdxDocument);
        if (uniqueDocAnnotations == null) {
            uniqueDocAnnotations = Maps.newHashMap();
            this.uniqueAnnotations.put(spdxDocument, uniqueDocAnnotations);
        }
        for (Map.Entry<SpdxDocument, SpdxItem> entry : this.documentItem.entrySet()) {
            Annotation[] compareAnnotations;
            Annotation[] uniqueAnnotations;
            HashMap compareDocAnnotations = this.uniqueAnnotations.get(entry.getKey());
            if (compareDocAnnotations == null) {
                compareDocAnnotations = Maps.newHashMap();
                this.uniqueAnnotations.put(entry.getKey(), compareDocAnnotations);
            }
            if ((uniqueAnnotations = SpdxComparer.findUniqueAnnotations(annotations, compareAnnotations = entry.getValue().getAnnotations())).length > 0) {
                this.annotationsEquals = false;
                this.differenceFound = true;
            }
            uniqueDocAnnotations.put(entry.getKey(), uniqueAnnotations);
            uniqueAnnotations = SpdxComparer.findUniqueAnnotations(compareAnnotations, annotations);
            if (uniqueAnnotations.length > 0) {
                this.annotationsEquals = false;
                this.differenceFound = true;
            }
            compareDocAnnotations.put(spdxDocument, uniqueAnnotations);
        }
    }

    private void compareRelationships(SpdxDocument spdxDocument, Relationship[] relationships) {
        HashMap uniqueDocRelationship = this.uniqueRelationships.get(spdxDocument);
        if (uniqueDocRelationship == null) {
            uniqueDocRelationship = Maps.newHashMap();
            this.uniqueRelationships.put(spdxDocument, uniqueDocRelationship);
        }
        for (Map.Entry<SpdxDocument, SpdxItem> entry : this.documentItem.entrySet()) {
            Relationship[] compareRelationships;
            Relationship[] uniqueRelationships;
            HashMap uniqueCompareRelationship = this.uniqueRelationships.get(entry.getKey());
            if (uniqueCompareRelationship == null) {
                uniqueCompareRelationship = Maps.newHashMap();
                this.uniqueRelationships.put(entry.getKey(), uniqueCompareRelationship);
            }
            if ((uniqueRelationships = SpdxComparer.findUniqueRelationships(relationships, compareRelationships = entry.getValue().getRelationships())).length > 0) {
                this.relationshipsEquals = false;
                this.differenceFound = true;
            }
            uniqueDocRelationship.put(entry.getKey(), uniqueRelationships);
            uniqueRelationships = SpdxComparer.findUniqueRelationships(compareRelationships, relationships);
            if (uniqueRelationships.length > 0) {
                this.relationshipsEquals = false;
                this.differenceFound = true;
            }
            uniqueCompareRelationship.put(spdxDocument, uniqueRelationships);
        }
    }

    private void compareLicenseInfosInFiles(SpdxDocument spdxDocument, AnyLicenseInfo[] licenses) throws SpdxCompareException {
        HashMap uniqueDocLicenses = this.uniqueLicenseInfosInFiles.get(spdxDocument);
        if (uniqueDocLicenses == null) {
            uniqueDocLicenses = Maps.newHashMap();
            this.uniqueLicenseInfosInFiles.put(spdxDocument, uniqueDocLicenses);
        }
        for (Map.Entry<SpdxDocument, SpdxItem> entry : this.documentItem.entrySet()) {
            HashMap uniqueCompareLicenses = this.uniqueLicenseInfosInFiles.get(entry.getKey());
            if (uniqueCompareLicenses == null) {
                uniqueCompareLicenses = Maps.newHashMap();
                this.uniqueLicenseInfosInFiles.put(entry.getKey(), uniqueCompareLicenses);
            }
            AnyLicenseInfo[] compareLicenses = entry.getValue().getLicenseInfoFromFiles();
            ArrayList uniqueInDoc = Lists.newArrayList();
            ArrayList uniqueInCompare = Lists.newArrayList();
            Map<String, String> licenseXlationMap = this.extractedLicenseIdMap.get(spdxDocument).get(entry.getKey());
            this.compareLicenseArrays(licenses, compareLicenses, uniqueInDoc, uniqueInCompare, licenseXlationMap);
            if (uniqueInDoc.size() > 0 || uniqueInCompare.size() > 0) {
                this.seenLicenseEquals = false;
                this.differenceFound = true;
            }
            uniqueDocLicenses.put(entry.getKey(), uniqueInDoc.toArray(new AnyLicenseInfo[uniqueInDoc.size()]));
            uniqueCompareLicenses.put(spdxDocument, uniqueInCompare.toArray(new AnyLicenseInfo[uniqueInCompare.size()]));
        }
    }

    private void compareLicenseArrays(AnyLicenseInfo[] licensesA, AnyLicenseInfo[] licensesB, List<AnyLicenseInfo> alUniqueA, List<AnyLicenseInfo> alUniqueB, Map<String, String> licenseXlationMap) throws SpdxCompareException {
        int j;
        boolean found;
        int i;
        for (i = 0; i < licensesA.length; ++i) {
            found = false;
            for (j = 0; j < licensesB.length; ++j) {
                if (!LicenseCompareHelper.isLicenseEqual(licensesA[i], licensesB[j], licenseXlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            alUniqueA.add(licensesA[i]);
        }
        for (i = 0; i < licensesB.length; ++i) {
            found = false;
            for (j = 0; j < licensesA.length; ++j) {
                if (!LicenseCompareHelper.isLicenseEqual(licensesA[j], licensesB[i], licenseXlationMap)) continue;
                found = true;
                break;
            }
            if (found) continue;
            alUniqueB.add(licensesB[i]);
        }
    }

    public boolean isConcludedLicenseEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.concludedLicenseEquals;
    }

    public boolean isSeenLicenseEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.seenLicenseEquals;
    }

    public AnyLicenseInfo[] getUniqueSeenLicenses(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        Map<SpdxDocument, AnyLicenseInfo[]> unique = this.uniqueLicenseInfosInFiles.get(docA);
        if (unique == null) {
            return new AnyLicenseInfo[0];
        }
        AnyLicenseInfo[] retval = unique.get(docB);
        if (retval == null) {
            return new AnyLicenseInfo[0];
        }
        return retval;
    }

    public boolean isCommentsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.commentsEquals;
    }

    public boolean isCopyrightsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.copyrightsEquals;
    }

    public boolean isLicenseCommmentsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.licenseCommmentsEquals;
    }

    protected void checkInProgress() throws SpdxCompareException {
        if (this.inProgress) {
            throw new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
    }

    private void checkCompareMade() throws SpdxCompareException {
        if (this.documentItem.entrySet().size() < 1) {
            throw new SpdxCompareException("Trying to obtain results of a file compare before a file compare has been performed");
        }
    }

    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.differenceFound;
    }

    public boolean isInProgress() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.inProgress;
    }

    public SpdxItem getItem(SpdxDocument doc) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.documentItem.get(doc);
    }

    public boolean isRelationshipsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.relationshipsEquals;
    }

    public Relationship[] getUniqueRelationship(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        Map<SpdxDocument, Relationship[]> unique = this.uniqueRelationships.get(docA);
        if (unique == null) {
            return new Relationship[0];
        }
        Relationship[] retval = unique.get(docB);
        if (retval == null) {
            return new Relationship[0];
        }
        return retval;
    }

    public boolean isAnnotationsEquals() throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        return this.annotationsEquals;
    }

    public Annotation[] getUniqueAnnotations(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        this.checkCompareMade();
        Map<SpdxDocument, Annotation[]> unique = this.uniqueAnnotations.get(docA);
        if (unique == null) {
            return new Annotation[0];
        }
        Annotation[] retval = unique.get(docB);
        if (retval == null) {
            return new Annotation[0];
        }
        return retval;
    }
}

