/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileNoticeSheet
extends AbstractFileCompareSheet {
    private static final int FILE_NOTICE_COL_WIDTH = 60;

    public FileNoticeSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return SpdxComparer.stringsEqual(fileA.getNoticeText(), fileB.getNoticeText());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        String retval = spdxFile.getNoticeText();
        if (retval == null) {
            return "";
        }
        return retval;
    }
}

