/*
 * Decompiled with CFR 0.152.
 */
package org.sourcelab.kafka.connect.apiclient.request.get;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.sourcelab.kafka.connect.apiclient.request.JacksonFactory;
import org.sourcelab.kafka.connect.apiclient.request.get.GetRequest;

public final class GetConnectorConfig
implements GetRequest<Map<String, String>> {
    private final String connectorName;

    public GetConnectorConfig(String connectorName) {
        Objects.requireNonNull(connectorName);
        this.connectorName = connectorName;
    }

    @Override
    public String getApiEndpoint() {
        return "/connectors/" + UrlEscapers.urlPathSegmentEscaper().escape(this.connectorName) + "/config";
    }

    @Override
    public Map<String, String> parseResponse(String responseStr) throws IOException {
        return (Map)JacksonFactory.newInstance().readValue(responseStr, (JavaType)JacksonFactory.mapTypeStringString);
    }
}

