/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

class ResourceAccessor {
    ResourceAccessor() {
    }

    public static URL getResource(String uri) throws URISyntaxException, MalformedURLException {
        return ResourceAccessor.getResource(new URI(uri));
    }

    public static URL getResource(URI uri) throws MalformedURLException {
        if (uri.getScheme() == null || uri.getScheme().equals("classpath")) {
            String path = uri.getSchemeSpecificPart();
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            return ResourceAccessor.getResource(path, Thread.currentThread().getContextClassLoader());
        }
        return uri.toURL();
    }

    public static URL getResource(String name, Class<?> relativeToClass) {
        return relativeToClass.getResource(name);
    }

    public static URL getResource(String name, ClassLoader classLoader) {
        return classLoader.getResource(name);
    }

    public static InputStream getResourceAsStream(String uri) throws URISyntaxException, MalformedURLException, IOException {
        return ResourceAccessor.getResourceAsStream(new URI(uri));
    }

    public static InputStream getResourceAsStream(URI uri) throws MalformedURLException, IOException {
        URL location = ResourceAccessor.getResource(uri);
        ResourceAccessor.assertNotNull(location, new FileNotFoundException(uri.toString()));
        return location.openStream();
    }

    public static InputStream getResourceAsStream(URL location) throws MalformedURLException, IOException {
        return location.openStream();
    }

    public static InputStream getResourceAsStream(String name, Class<?> relativeToClass) throws IOException {
        URL location = ResourceAccessor.getResource(name, relativeToClass);
        ResourceAccessor.assertNotNull(location, new FileNotFoundException(relativeToClass.getPackage().getName() + "." + name));
        return location.openStream();
    }

    public static InputStream getResourceAsStream(String name, ClassLoader classLoader) throws IOException {
        URL location = ResourceAccessor.getResource(name, classLoader);
        ResourceAccessor.assertNotNull(location, new FileNotFoundException(name));
        return location.openStream();
    }

    private static void assertNotNull(URL location, IOException ex) throws IOException {
        if (location == null) {
            throw ex;
        }
    }
}

