/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.ssl;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

class OptionSet {
    private final Set<String> excludedOptions = new LinkedHashSet<String>();
    private final Set<String> includedOptions = new LinkedHashSet<String>();

    OptionSet() {
    }

    public void excludeOptions(String ... options) {
        this.excludedOptions.addAll(Arrays.asList(options));
    }

    public void includeOptions(String ... options) {
        this.includedOptions.addAll(Arrays.asList(options));
    }

    public String[] enabledOptions(String[] supportedOptions, String[] defaultOptions) {
        if (this.excludedOptions.isEmpty() && this.includedOptions.isEmpty()) {
            return defaultOptions;
        }
        Collection<String> enabledOptions = this.enabledOptions(Arrays.asList(supportedOptions), Arrays.asList(defaultOptions));
        return enabledOptions.toArray(new String[enabledOptions.size()]);
    }

    public Collection<String> enabledOptions(Collection<String> supportedOptions, Collection<String> defaultOptions) {
        if (this.excludedOptions.isEmpty() && this.includedOptions.isEmpty()) {
            return defaultOptions;
        }
        Collection<String> supportedAndIncludedOptions = this.retainMatching(supportedOptions, this.includedOptions);
        return this.removeMatching(supportedAndIncludedOptions, this.excludedOptions);
    }

    private Collection<String> retainMatching(Collection<String> strings, Set<String> patterns) {
        if (patterns.isEmpty()) {
            return strings;
        }
        return this.findMatches(strings, patterns);
    }

    private Collection<String> removeMatching(Collection<String> strings, Set<String> patterns) {
        if (patterns.isEmpty()) {
            return strings;
        }
        Set<String> matches = this.findMatches(strings, patterns);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(strings);
        result.removeAll(matches);
        return result;
    }

    private Set<String> findMatches(Collection<String> strings, Set<String> patterns) {
        LinkedHashSet<String> matches = new LinkedHashSet<String>();
        for (String p : patterns) {
            Pattern pattern = Pattern.compile(p);
            for (String s : strings) {
                if (!pattern.matcher(s).matches()) continue;
                matches.add(s);
            }
        }
        return matches;
    }
}

