/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.transformer;

import java.util.Properties;
import javax.xml.transform.Transformer;
import org.soulwing.cas.api.AttributeTransformer;

public class FlattenCaseTransformer
extends AttributeTransformer<String, String> {
    public static final String USE_UPPER_CASE = "use-upper-case";
    private boolean useUpperCase;

    public void initialize(Properties properties) {
        super.initialize(properties);
        this.useUpperCase = Boolean.parseBoolean(properties.getProperty(USE_UPPER_CASE, Boolean.FALSE.toString()));
    }

    public String transform(String value) {
        if (this.useUpperCase) {
            return value.toUpperCase();
        }
        return value.toLowerCase();
    }

    public String toString() {
        return String.format("%s(%s=%s)", ((Object)((Object)this)).getClass().getSimpleName().replaceFirst(Transformer.class.getSimpleName() + "$", ""), USE_UPPER_CASE, this.useUpperCase);
    }
}

