/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.transformer;

import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.transform.Transformer;
import org.soulwing.cas.api.AttributeTransformer;

public class DistinguishedToSimpleNameTransformer
extends AttributeTransformer<String, String> {
    public static final String NAME_COMPONENT = "name-component";
    public static final String FAIL_ON_ERROR = "fail-on-error";
    public static final String DEFAULT_NAME_COMPONENT = "cn";
    private String nameComponent;
    private boolean failOnError;

    public void initialize(Properties properties) {
        super.initialize(properties);
        this.nameComponent = properties.getProperty(NAME_COMPONENT, DEFAULT_NAME_COMPONENT);
        this.failOnError = Boolean.parseBoolean(properties.getProperty(FAIL_ON_ERROR, Boolean.FALSE.toString()));
    }

    public String transform(String value) {
        try {
            LdapName name = new LdapName(value);
            for (Rdn rdn : name.getRdns()) {
                if (!this.nameComponent.equalsIgnoreCase(rdn.getType())) continue;
                return rdn.getValue().toString();
            }
            if (!this.failOnError) {
                return value;
            }
            throw new IllegalArgumentException("does not contain a '" + this.nameComponent + "' component: '" + value + "'");
        }
        catch (InvalidNameException ex) {
            if (!this.failOnError) {
                return value;
            }
            throw new IllegalArgumentException("not a valid LDAP name: '" + value + "'");
        }
    }

    public String toString() {
        return String.format("%s(%s=%s, %s=%s)", ((Object)((Object)this)).getClass().getSimpleName().replaceFirst(Transformer.class.getSimpleName() + "$", ""), NAME_COMPONENT, this.nameComponent, FAIL_ON_ERROR, this.failOnError);
    }
}

