/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.ssl;

import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.soulwing.cas.ssl.HostnameVerifierType;

class WhiteListHostnameVerifier
implements HostnameVerifier {
    private final String[] allowedHosts;

    public WhiteListHostnameVerifier(String[] allowedHosts) {
        this.allowedHosts = allowedHosts;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        for (String allowedHost : this.allowedHosts) {
            if (!hostname.equalsIgnoreCase(allowedHost)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s(hosts=%s)", new Object[]{HostnameVerifierType.WHITE_LIST, Arrays.asList(this.allowedHosts)});
    }
}

