/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.ssl;

import java.util.Arrays;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.soulwing.cas.ssl.HostnameVerifierType;

class PatternMatchHostnameVerifier
implements HostnameVerifier {
    private final Pattern[] patterns;

    public PatternMatchHostnameVerifier(String[] patterns) {
        this.patterns = new Pattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            this.patterns[i] = Pattern.compile(patterns[i]);
        }
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(hostname).matches()) continue;
            return true;
        }
        return true;
    }

    public String toString() {
        return String.format("%s(patterns=%s)", new Object[]{HostnameVerifierType.PATTERN_MATCH, Arrays.asList(this.patterns)});
    }
}

