/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.service;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.soulwing.cas.api.Transformer;

class TransformingMap
extends AbstractMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = -217419703730591133L;
    private final Lock lock = new ReentrantLock();
    private final Map<String, Object> delegate;
    private final Map<String, Transformer<Object, Object>> transformers;
    private Set<Map.Entry<String, Object>> entrySet;

    public TransformingMap(Map<String, Object> delegate, Map<String, Transformer<Object, Object>> transformers) {
        this.delegate = delegate;
        this.transformers = transformers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            this.lock.lock();
            try {
                if (this.entrySet == null) {
                    this.entrySet = new LinkedHashSet<Map.Entry<String, Object>>();
                    for (String key : this.delegate.keySet()) {
                        Transformer<Object, Object> transformer = this.transformers.get(key);
                        Object s = this.delegate.get(key);
                        Object t = this.transform(s, transformer);
                        this.entrySet.add(new AbstractMap.SimpleEntry<String, Object>(key, t));
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.entrySet;
    }

    private Object transform(Object s, Transformer<Object, Object> transformer) {
        if (transformer == null) {
            return s;
        }
        if (s instanceof Iterable) {
            LinkedList<Object> t = new LinkedList<Object>();
            for (Object obj : (Iterable)s) {
                t.add(transformer.transform(obj));
            }
            return t;
        }
        return transformer.transform(s);
    }
}

