/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.service;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.soulwing.cas.api.IdentityAssertion;
import org.soulwing.cas.service.AuthenticationException;
import org.soulwing.cas.service.Authenticator;
import org.soulwing.cas.service.Configuration;
import org.soulwing.cas.service.JasigIdentityAssertion;
import org.soulwing.cas.service.NoTicketException;
import org.soulwing.cas.service.QueryUtil;
import org.soulwing.cas.service.ServiceLogger;

public class JasigAuthenticator
implements Authenticator,
Serializable {
    private static final long serialVersionUID = 364417311301329226L;
    public static final String LOGIN_PATH = "login";
    public static final String LOGOUT_PATH = "logout";
    private final Configuration config;
    private final transient TicketValidator validator;

    public JasigAuthenticator(Configuration config, TicketValidator validator) {
        this.config = config;
        this.validator = validator;
    }

    TicketValidator getValidator() {
        return this.validator;
    }

    @Override
    public boolean isPostAuthRedirect() {
        return this.config.isPostAuthRedirect();
    }

    @Override
    public String loginUrl(String requestPath, String queryString) {
        String serviceUrl = this.serviceUrl(requestPath, queryString);
        String loginUrl = CommonUtils.constructRedirectUrl((String)this.appendPathToUrl(this.config.getServerUrl(), LOGIN_PATH), (String)this.config.getProtocol().getServiceParameterName(), (String)serviceUrl, (boolean)this.config.isRenew(), (boolean)false);
        return loginUrl;
    }

    @Override
    public String logoutUrl(String path) {
        if (path != null && !path.startsWith("/")) {
            throw new IllegalArgumentException("must specify an absolute path for an application resource");
        }
        StringBuilder url = new StringBuilder();
        String serverUrl = this.config.getServerUrl();
        url.append(this.appendPathToUrl(serverUrl, LOGOUT_PATH));
        if (path != null) {
            url.append("?url=");
            url.append(CommonUtils.urlEncode((String)this.applicationUrl(path)));
        }
        return url.toString();
    }

    private String appendPathToUrl(String url, String path) {
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        if (!url.endsWith("/") && !path.startsWith("/")) {
            sb.append("/");
        }
        sb.append(path);
        return sb.toString();
    }

    private String applicationUrl(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("must specify an absolute path for an application resource");
        }
        URI uri = URI.create(this.config.getServiceUrl());
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme());
        sb.append("://");
        sb.append(uri.getAuthority());
        sb.append(path);
        return sb.toString();
    }

    @Override
    public IdentityAssertion validateTicket(String requestPath, String queryString) throws NoTicketException, AuthenticationException {
        String ticket = QueryUtil.findParameter(this.config.getProtocol().getTicketParameterName(), queryString);
        if (ticket == null) {
            throw new NoTicketException();
        }
        try {
            ticket = URLDecoder.decode(ticket, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AuthenticationException("cannot decode ticket", ex);
        }
        String serviceUrl = this.serviceUrl(requestPath, queryString);
        if (ServiceLogger.LOGGER.isDebugEnabled()) {
            ServiceLogger.LOGGER.debug((Object)("validating ticket '" + ticket + "' for service " + serviceUrl));
        }
        try {
            return new JasigIdentityAssertion(this, this.validator.validate(ticket, serviceUrl), this.config.getAttributeTransformers());
        }
        catch (TicketValidationException ex) {
            throw new AuthenticationException(ex.getMessage(), ex);
        }
    }

    @Override
    public String postAuthUrl(String requestUrl, String queryString) {
        StringBuilder sb = new StringBuilder();
        sb.append(requestUrl);
        queryString = QueryUtil.removeProtocolParameters(this.config.getProtocol(), queryString);
        if (!queryString.isEmpty()) {
            sb.append('?');
            sb.append(queryString);
        }
        return sb.toString();
    }

    String serviceUrl(String requestPath, String queryString) {
        URI uri = URI.create(this.config.getServiceUrl());
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme());
        sb.append("://");
        sb.append(uri.getAuthority());
        sb.append(requestPath);
        queryString = QueryUtil.removeProtocolParameters(this.config.getProtocol(), queryString);
        if (!queryString.isEmpty()) {
            sb.append('?');
            sb.append(queryString);
        }
        return sb.toString();
    }
}

