/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.service;

public enum AuthenticationProtocol {
    CAS1_0("CAS-1.0"),
    CAS2_0("CAS-2.0"),
    CAS3_0("CAS-3.0"),
    SAML1_1("SAML-1.1", "TARGET", "SAMLart");

    private final String displayName;
    private final String serviceParameterName;
    private final String ticketParameterName;

    private AuthenticationProtocol(String displayName) {
        this(displayName, "service", "ticket");
    }

    private AuthenticationProtocol(String displayName, String serviceParameterName, String ticketParameterName) {
        this.displayName = displayName;
        this.serviceParameterName = serviceParameterName;
        this.ticketParameterName = ticketParameterName;
    }

    public String getServiceParameterName() {
        return this.serviceParameterName;
    }

    public String getTicketParameterName() {
        return this.ticketParameterName;
    }

    public String toString() {
        return this.displayName;
    }

    public static AuthenticationProtocol toObject(String displayName) {
        for (AuthenticationProtocol protocol : AuthenticationProtocol.values()) {
            if (!protocol.toString().equals(displayName)) continue;
            return protocol;
        }
        throw new IllegalArgumentException("invalid name");
    }
}

