/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.jaas;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.callback.ObjectCallback;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.soulwing.cas.api.IdentityAssertion;
import org.soulwing.cas.api.UserPrincipal;
import org.soulwing.cas.jaas.IdentityAssertionHolder;
import org.soulwing.cas.jaas.JaasLogger;

public class IdentityAssertionLoginModule
extends AbstractServerLoginModule {
    public static final String ROLE_ATTRIBUTES = "role-attributes";
    private String[] roleAttributes;
    protected IdentityAssertion assertion;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.roleAttributes = IdentityAssertionLoginModule.parseRoleAttributes(options.get(ROLE_ATTRIBUTES));
        if (JaasLogger.LOGGER.isDebugEnabled()) {
            JaasLogger.LOGGER.debug((Object)("role attributes: " + Arrays.asList(this.roleAttributes)));
        }
    }

    private static String[] parseRoleAttributes(Object attrs) {
        if (attrs == null) {
            return new String[0];
        }
        String attributes = attrs.toString();
        if (attributes.isEmpty()) {
            return new String[0];
        }
        return attributes.split("\\s*(,|\\s)\\s*");
    }

    public boolean login() throws LoginException {
        ObjectCallback callback = new ObjectCallback("Credential");
        try {
            this.callbackHandler.handle(new Callback[]{callback});
            Object obj = callback.getCredential();
            if (!(obj instanceof IdentityAssertionHolder)) {
                if (JaasLogger.LOGGER.isDebugEnabled()) {
                    JaasLogger.LOGGER.debug((Object)"credential object is not an identity assertion");
                }
                return false;
            }
            this.assertion = ((IdentityAssertionHolder)obj).getIdentityAssertion();
            this.loginOk = true;
            return true;
        }
        catch (UnsupportedCallbackException ex) {
            throw new LoginException("ObjectCallback not supported");
        }
        catch (IOException ex) {
            throw new LoginException("I/O error: " + ex.toString());
        }
    }

    protected Principal getIdentity() {
        UserPrincipal principal = this.assertion.getPrincipal();
        if (JaasLogger.LOGGER.isDebugEnabled()) {
            JaasLogger.LOGGER.debug((Object)("identity assertion for principal '" + principal.getName() + "'"));
        }
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        Set<Principal> roles = this.getRoles();
        if (roles.isEmpty()) {
            return new Group[0];
        }
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        for (Principal role : roles) {
            rolesGroup.addMember(role);
        }
        return new Group[]{rolesGroup};
    }

    protected Set<Principal> getRoles() throws LoginException {
        LinkedHashSet<Principal> roles = new LinkedHashSet<Principal>();
        if (this.roleAttributes.length > 0) {
            Map attributes = this.assertion.getPrincipal().getAttributes();
            for (String roleAttribute : this.roleAttributes) {
                Object attrValue = attributes.get(roleAttribute);
                if (attrValue instanceof Collection) {
                    for (Object value : (Collection)attrValue) {
                        roles.add(this.createRole(value.toString()));
                    }
                    continue;
                }
                if (attrValue != null) {
                    roles.add(this.createRole(attrValue.toString()));
                    continue;
                }
                if (!JaasLogger.LOGGER.isDebugEnabled()) continue;
                JaasLogger.LOGGER.debug((Object)("assertion does not contain attribute '" + roleAttribute + "'"));
            }
        }
        if (JaasLogger.LOGGER.isDebugEnabled()) {
            JaasLogger.LOGGER.debug((Object)("assertion-derived roles: " + roles));
        }
        return roles;
    }

    protected Principal createRole(String name) throws LoginException {
        try {
            Principal role = this.createIdentity(name);
            if (JaasLogger.LOGGER.isDebugEnabled()) {
                JaasLogger.LOGGER.debug((Object)("created role principal '" + name + "'"));
            }
            return role;
        }
        catch (Exception ex) {
            JaasLogger.LOGGER.error((Object)("while creating role '" + name + "': " + ex), (Throwable)ex);
            throw new LoginException("cannot create role: " + name);
        }
    }
}

