/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.soulwing.cas.extension.Paths;
import org.soulwing.cas.extension.ProfileDefinition;
import org.soulwing.cas.extension.ProfileService;
import org.soulwing.cas.extension.ResourceUtil;

public class TransformerDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition CODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("code", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES, AttributeAccess.Flag.STORAGE_CONFIGURATION})).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).build();
    static final SimpleMapAttributeDefinition OPTIONS = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("options", false).setAllowNull(true)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES, AttributeAccess.Flag.STORAGE_CONFIGURATION})).build();
    public static final TransformerDefinition INSTANCE = new TransformerDefinition();

    public static AttributeDefinition[] attributes() {
        return new AttributeDefinition[]{CODE, MODULE, OPTIONS};
    }

    private TransformerDefinition() {
        super(Paths.TRANSFORMER, (ResourceDescriptionResolver)ResourceUtil.getResolver("cas-profile", "attribute-transform", "transformer"), (OperationStepHandler)TransformerAdd.INSTANCE, (OperationStepHandler)TransformerRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : TransformerDefinition.attributes()) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)ProfileDefinition.ProfileWriteAttributeHandler.INSTANCE);
        }
        super.registerAttributes(resourceRegistration);
    }

    static class TransformerRemove
    extends RestartParentResourceRemoveHandler {
        static final TransformerRemove INSTANCE = new TransformerRemove();

        private TransformerRemove() {
            super("cas-profile");
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ProfileService.ServiceUtil.installService(context, parentModel, parentAddress);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ProfileService.ServiceUtil.profileServiceName(parentAddress);
        }
    }

    static class TransformerAdd
    extends RestartParentResourceAddHandler {
        static final TransformerAdd INSTANCE = new TransformerAdd();

        private TransformerAdd() {
            super("cas-profile");
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : TransformerDefinition.attributes()) {
                attribute.validateAndSet(operation, model);
            }
            ModelNode code = model.get("code");
            if (!code.isDefined()) {
                PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                String name = address.getLastElement().getValue();
                code.set(name);
            }
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ProfileService.ServiceUtil.installService(context, parentModel, parentAddress);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ProfileService.ServiceUtil.profileServiceName(parentAddress);
        }
    }
}

