/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.soulwing.cas.extension.Paths;
import org.soulwing.cas.extension.ProfileDefinition;
import org.soulwing.cas.extension.ProfileService;
import org.soulwing.cas.extension.ResourceUtil;

class ProxyChainDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition PROXY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("proxy", ModelType.STRING).setAllowExpression(true)).setAllowNull(false)).build();
    static final SimpleListAttributeDefinition PROXIES = ((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)SimpleListAttributeDefinition.Builder.of((String)"proxies", (AttributeDefinition)PROXY).setAllowNull(false).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES, AttributeAccess.Flag.STORAGE_CONFIGURATION})).build();
    public static final ProxyChainDefinition INSTANCE = new ProxyChainDefinition();

    public static AttributeDefinition[] attributes() {
        return new AttributeDefinition[]{PROXIES};
    }

    private ProxyChainDefinition() {
        super(Paths.PROXY_CHAIN, (ResourceDescriptionResolver)ResourceUtil.getResolver("cas-profile", "allowed-proxy-chain"), (OperationStepHandler)ProxyChainAdd.INSTANCE, (OperationStepHandler)ProxyChainRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : ProxyChainDefinition.attributes()) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)ProfileDefinition.ProfileWriteAttributeHandler.INSTANCE);
        }
        super.registerAttributes(resourceRegistration);
    }

    static class ProxyChainRemove
    extends RestartParentResourceRemoveHandler {
        static final ProxyChainRemove INSTANCE = new ProxyChainRemove();

        private ProxyChainRemove() {
            super("cas-profile");
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ProfileService.ServiceUtil.profileServiceName(parentAddress);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ProfileService.ServiceUtil.installService(context, parentModel, parentAddress);
        }
    }

    static class ProxyChainAdd
    extends RestartParentResourceAddHandler {
        static final ProxyChainAdd INSTANCE = new ProxyChainAdd();

        private ProxyChainAdd() {
            super("cas-profile");
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : ProxyChainDefinition.attributes()) {
                attribute.validateAndSet(operation, model);
            }
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ProfileService.ServiceUtil.profileServiceName(parentAddress);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ProfileService.ServiceUtil.installService(context, parentModel, parentAddress);
        }
    }
}

