/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.SSLContextService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.soulwing.cas.api.Transformer;
import org.soulwing.cas.extension.ExtensionLogger;
import org.soulwing.cas.extension.Profile;
import org.soulwing.cas.extension.ProfileDefinition;
import org.soulwing.cas.service.AuthenticationProtocol;
import org.soulwing.cas.ssl.HostnameVerifierFactory;
import org.soulwing.cas.ssl.HostnameVerifierType;
import org.soulwing.cas.transformer.TransformerFactory;
import org.soulwing.cas.transformer.TransformerLoadException;
import org.soulwing.cas.transformer.TransformerSequence;

public class ProfileService
extends AbstractService<Profile> {
    private final Profile profile;

    public ProfileService(Profile profile) {
        this.profile = profile;
    }

    public Injector<SSLContext> getSslContextInjector() {
        return this.profile.getSslContextInjector();
    }

    public Profile getValue() throws IllegalStateException {
        return this.profile;
    }

    public static class ServiceUtil {
        public static ServiceName profileServiceName(PathAddress profileAddress) {
            return ServiceUtil.profileServiceName(ServiceUtil.profileName(profileAddress));
        }

        public static ServiceName profileServiceName(String profileName) {
            return ServiceName.of((String[])new String[]{"cas", "cas-profile", profileName});
        }

        public static ServiceController<?> installService(OperationContext context, ModelNode model, PathAddress profileAddress) throws OperationFailedException {
            Resource resource = context.readResourceFromRoot(profileAddress, true);
            Profile profile = ServiceUtil.createProfile(context, model);
            ServiceUtil.addAllowedProxyChains(resource, profile);
            ServiceUtil.addHostnameVerifier(resource, profile);
            ServiceUtil.addAttributeTransforms(resource, profile);
            ProfileService profileService = new ProfileService(profile);
            ServiceBuilder builder = context.getServiceTarget().addService(ServiceUtil.profileServiceName(profileAddress), (Service)profileService);
            if (profile.getSecurityRealm() != null) {
                SSLContextService.ServiceUtil.addDependency((ServiceBuilder)builder, profileService.getSslContextInjector(), (ServiceName)SecurityRealm.ServiceUtil.createServiceName((String)profile.getSecurityRealm()), (boolean)false);
            }
            ServiceController controller = builder.install();
            ExtensionLogger.LOGGER.debug((Object)("installed " + controller.getName() + " with profile " + profile));
            return controller;
        }

        private static String profileName(PathAddress profileAddress) {
            PathElement pathElement = profileAddress.getLastElement();
            String key = pathElement.getKey();
            if (!key.equals("cas-profile")) {
                throw new IllegalArgumentException("not a profile address");
            }
            return pathElement.getValue();
        }

        public static void removeService(OperationContext context, PathAddress profileAddress) throws OperationFailedException {
            ServiceUtil.removeService(context, ServiceUtil.profileName(profileAddress));
        }

        public static void removeService(OperationContext context, String profileName) throws OperationFailedException {
            ServiceName serviceName = ServiceUtil.profileServiceName(profileName);
            context.removeService(serviceName);
            ExtensionLogger.LOGGER.debug((Object)("removed " + serviceName));
        }

        private static Profile createProfile(OperationContext context, ModelNode model) throws OperationFailedException {
            Profile config = new Profile();
            config.setProtocol(AuthenticationProtocol.toObject(ProfileDefinition.PROTOCOL.resolveModelAttribute(context, model).asString()));
            config.setEncoding(ProfileDefinition.ENCODING.resolveModelAttribute(context, model).asString());
            config.setServerUrl(ProfileDefinition.SERVER_URL.resolveModelAttribute(context, model).asString());
            config.setServiceUrl(ProfileDefinition.SERVICE_URL.resolveModelAttribute(context, model).asString());
            config.setProxyCallbackEnabled(ProfileDefinition.PROXY_CALLBACK_ENABLED.resolveModelAttribute(context, model).asBoolean());
            config.setProxyCallbackPath(ProfileDefinition.PROXY_CALLBACK_PATH.resolveModelAttribute(context, model).asString());
            config.setAcceptAnyProxy(ProfileDefinition.ACCEPT_ANY_PROXY.resolveModelAttribute(context, model).asBoolean());
            config.setAllowEmptyProxyChain(ProfileDefinition.ALLOW_EMPTY_PROXY_CHAIN.resolveModelAttribute(context, model).asBoolean());
            config.setRenew(ProfileDefinition.RENEW.resolveModelAttribute(context, model).asBoolean());
            config.setClockSkewTolerance(ProfileDefinition.CLOCK_SKEW_TOLERANCE.resolveModelAttribute(context, model).asLong());
            config.setPostAuthRedirect(ProfileDefinition.POST_AUTH_REDIRECT.resolveModelAttribute(context, model).asBoolean());
            ModelNode securityRealm = ProfileDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
            if (securityRealm.isDefined()) {
                config.setSecurityRealm(securityRealm.asString());
            }
            return config;
        }

        private static void addAllowedProxyChains(Resource profileResource, Profile config) {
            for (String name : profileResource.getChildrenNames("allowed-proxy-chain")) {
                ModelNode chain = profileResource.getChild(PathElement.pathElement((String)"allowed-proxy-chain", (String)name)).getModel();
                ArrayList<String> proxies = new ArrayList<String>();
                if (chain.has("proxies")) {
                    for (ModelNode proxy : chain.get("proxies").asList()) {
                        proxies.add(proxy.asString());
                    }
                }
                config.putAllowedProxyChain(name, proxies);
            }
        }

        private static void addHostnameVerifier(Resource profileResource, Profile config) throws OperationFailedException {
            Set names = profileResource.getChildrenNames("hostname-verifier");
            if (names.size() > 1) {
                throw new OperationFailedException("too many server host verifiers");
            }
            if (names.isEmpty()) {
                return;
            }
            String name = (String)names.iterator().next();
            ModelNode model = profileResource.getChild(PathElement.pathElement((String)"hostname-verifier", (String)name)).getModel();
            config.setHostnameVerifier(HostnameVerifierFactory.newInstance(HostnameVerifierType.toObject(name), ServiceUtil.createHosts(model)));
        }

        private static String[] createHosts(ModelNode model) {
            ModelNode hostsModel;
            ArrayList<String> hosts = new ArrayList<String>();
            if (model.has("hosts") && (hostsModel = model.get("hosts")).isDefined()) {
                for (ModelNode host : hostsModel.asList()) {
                    hosts.add(host.asString());
                }
            }
            return hosts.toArray(new String[hosts.size()]);
        }

        private static void addAttributeTransforms(Resource profileResource, Profile config) throws OperationFailedException {
            for (String name : profileResource.getChildrenNames("attribute-transform")) {
                Resource transformResource = profileResource.getChild(PathElement.pathElement((String)"attribute-transform", (String)name));
                ServiceUtil.addAttributeTransformers(name, transformResource, config);
            }
        }

        private static void addAttributeTransformers(String attributeName, Resource transformResource, Profile config) throws OperationFailedException {
            ArrayList transformers = new ArrayList();
            for (String name : transformResource.getChildrenNames("transformer")) {
                ModelNode model = transformResource.getChild(PathElement.pathElement((String)"transformer", (String)name)).getModel();
                ModelNode code = model.get("code");
                ModelNode module = model.get("module");
                ModelNode options = model.get("options");
                try {
                    Transformer<?, ?> transformer = TransformerFactory.getTransformer(code.isDefined() ? code.asString() : null, module.isDefined() ? module.asString() : null, ServiceUtil.toProperties(options));
                    transformers.add(transformer);
                }
                catch (TransformerLoadException ex) {
                    throw new OperationFailedException(ex.getMessage(), (Throwable)ex);
                }
            }
            int count = transformers.size();
            if (count > 1) {
                config.putAttributeTransformer(attributeName, new TransformerSequence(transformers));
            } else if (count == 1) {
                config.putAttributeTransformer(attributeName, (Transformer)transformers.get(0));
            }
        }

        private static Properties toProperties(ModelNode options) {
            Properties properties = new Properties();
            if (options.isDefined()) {
                for (String key : options.keys()) {
                    properties.put(key, options.get(key).asString());
                }
            }
            return properties;
        }
    }
}

