/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.soulwing.cas.extension.AbstractResourceReaderWriter;
import org.soulwing.cas.extension.ParserAttachments;
import org.soulwing.cas.extension.TransformerDefinition;

class OptionReaderWriter
extends AbstractResourceReaderWriter {
    public OptionReaderWriter() {
        super("option");
    }

    @Override
    protected void handleAttributes(XMLStreamReader reader) throws XMLStreamException {
        String key = null;
        int max = reader.getAttributeCount();
        for (int i = 0; i < max; ++i) {
            String localName = reader.getAttributeLocalName(i);
            if ("key".equals(localName)) {
                if (key == null) {
                    key = reader.getAttributeValue(i);
                    continue;
                }
                this.parser.duplicateAttribute(reader, localName);
                continue;
            }
            this.parser.unexpectedAttribute(reader, i);
        }
        if (key == null) {
            this.parser.missingAttributes(reader, Collections.singleton("key"));
        }
        this.parser.putAttachment(ParserAttachments.OPTION_KEY, key);
    }

    @Override
    public void characters(XMLStreamReader reader, String text) throws XMLStreamException {
        String key = this.parser.removeAttachment(ParserAttachments.OPTION_KEY);
        if (key == null) {
            throw new XMLStreamException("no key for option text");
        }
        ModelNode value = TransformerDefinition.OPTIONS.parse(text, reader.getLocation());
        this.parser.lastOperation().get("options").get(key).set(value);
    }

    @Override
    public void writeResource(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement("option");
        String key = node.get(0).asString();
        String value = node.get(1).asString();
        writer.writeAttribute("key", key);
        writer.writeCharacters(value);
        writer.writeEndElement();
    }
}

