/*
 * Decompiled with CFR 0.152.
 */
package org.soulwing.cas.extension;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.soulwing.cas.extension.Paths;
import org.soulwing.cas.extension.ProfileDefinition;
import org.soulwing.cas.extension.ProfileService;
import org.soulwing.cas.extension.ResourceUtil;

class HostnameVerifierDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition HOST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("host", ModelType.STRING).setAllowExpression(true)).setAllowNull(false)).build();
    static final SimpleListAttributeDefinition HOSTS = ((SimpleListAttributeDefinition.Builder)((SimpleListAttributeDefinition.Builder)SimpleListAttributeDefinition.Builder.of((String)"hosts", (AttributeDefinition)HOST).setAllowNull(true).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES, AttributeAccess.Flag.STORAGE_CONFIGURATION})).build();
    public static final HostnameVerifierDefinition INSTANCE = new HostnameVerifierDefinition();

    private HostnameVerifierDefinition() {
        super(Paths.SERVER_HOST_VERIFIER, (ResourceDescriptionResolver)ResourceUtil.getResolver("cas-profile", "hostname-verifier"), (OperationStepHandler)HostnameVerifierAdd.INSTANCE, (OperationStepHandler)HostnameVerifierRemove.INSTANCE);
    }

    public static AttributeDefinition[] attributes() {
        return new AttributeDefinition[]{HOSTS};
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attribute : HostnameVerifierDefinition.attributes()) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)ProfileDefinition.ProfileWriteAttributeHandler.INSTANCE);
        }
        super.registerAttributes(resourceRegistration);
    }

    static class HostnameVerifierValidationHandler
    implements OperationStepHandler {
        static final OperationStepHandler INSTANCE = new HostnameVerifierValidationHandler();

        private HostnameVerifierValidationHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            if (resource.getChildrenNames("hostname-verifier").size() > 1) {
                throw new OperationFailedException("no more than one hostname-verifier may be configured");
            }
        }
    }

    static class HostnameVerifierRemove
    extends RestartParentResourceRemoveHandler {
        static final HostnameVerifierRemove INSTANCE = new HostnameVerifierRemove();

        private HostnameVerifierRemove() {
            super("cas-profile");
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ProfileService.ServiceUtil.profileServiceName(parentAddress);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ProfileService.ServiceUtil.installService(context, parentModel, parentAddress);
        }
    }

    static class HostnameVerifierAdd
    extends RestartParentResourceAddHandler {
        static final HostnameVerifierAdd INSTANCE = new HostnameVerifierAdd();

        private HostnameVerifierAdd() {
            super("cas-profile");
        }

        protected void updateModel(OperationContext context, ModelNode operation) throws OperationFailedException {
            super.updateModel(context, operation);
            context.addStep(HostnameVerifierAdd.createValidateOperation(operation), HostnameVerifierValidationHandler.INSTANCE, OperationContext.Stage.MODEL);
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : HostnameVerifierDefinition.attributes()) {
                attribute.validateAndSet(operation, model);
            }
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return ProfileService.ServiceUtil.profileServiceName(parentAddress);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel) throws OperationFailedException {
            ProfileService.ServiceUtil.installService(context, parentModel, parentAddress);
        }

        private static ModelNode createValidateOperation(ModelNode operationToValidate) {
            PathAddress pa = PathAddress.pathAddress((ModelNode)operationToValidate.require("address"));
            PathAddress verifierAddr = null;
            for (int i = pa.size() - 1; i > 0; --i) {
                PathElement pe = pa.getElement(i);
                if (!"cas-profile".equals(pe.getKey())) continue;
                verifierAddr = pa.subAddress(0, i + 1);
                break;
            }
            assert (verifierAddr != null) : "operationToValidate did not have an address with cas-profile";
            return Util.getEmptyOperation((String)"validate-host-verifier", (ModelNode)verifierAddr.toModelNode());
        }
    }
}

